<?php $__env->startSection('title', 'İletişim - Aziz Usta'); ?>
<?php $__env->startSection('content'); ?>

    
    <section class="relative min-h-screen w-full bg-[#fcfdfd] pt-32 md:pt-44 pb-20 md:pb-32 px-4 md:px-6 overflow-hidden">

        <div class="absolute top-[-5%] left-[-5%] w-[20rem] md:w-[45rem] h-[20rem] md:h-[45rem] bg-[#e31e23]/5 rounded-full blur-[100px] -z-10 animate-pulse"></div>
        <div class="absolute bottom-[-5%] right-[-5%] w-[20rem] md:w-[45rem] h-[20rem] md:h-[45rem] bg-[#3fae2a]/5 rounded-full blur-[100px] -z-10 animate-pulse" style="animation-delay: 2s;"></div>

        <div class="max-w-7xl mx-auto relative z-10">

            <div class="text-center mb-12 md:mb-20 space-y-4 md:space-y-6">
                <div class="inline-flex items-center gap-2 glass-darker px-4 py-2 md:px-6 rounded-full border border-slate-200 shadow-sm">
                    <span class="w-2 h-2 rounded-full bg-[#e31e23] animate-ping"></span>
                    <span class="text-slate-800 font-black text-[8px] md:text-[10px] uppercase tracking-[0.2em] md:tracking-[0.4em]">Bizimle Bağlantı Kurun</span>
                </div>
                
                <h1 class="text-4xl md:text-6xl lg:text-8xl font-black text-slate-900 tracking-tighter leading-[0.9]">
                    Lezzetin Merkeziyle <br> <span class="text-[#3fae2a]">İletişime Geçin</span>
                </h1>
            </div>

            <div class="grid lg:grid-cols-12 gap-6 md:gap-8">

                
                <div class="lg:col-span-5 space-y-4 md:space-y-6">

                    
                    
                    <div class="glass p-6 md:p-10 rounded-[30px] md:rounded-[50px] border border-slate-200 shadow-xl group hover:bg-white transition-all duration-500">
                        <div class="flex items-start gap-4 md:gap-6">
                            <div class="w-12 h-12 md:w-14 md:h-14 rounded-2xl bg-red-50 text-[#e31e23] flex items-center justify-center flex-shrink-0 group-hover:scale-110 transition-transform">
                                <svg class="w-5 h-5 md:w-6 md:h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                            </div>
                            <div class="space-y-1 md:space-y-2 min-w-0"> 
                                <h4 class="text-[10px] md:text-xs font-black text-slate-400 uppercase tracking-widest">Genel Merkez</h4>
                                <p class="text-lg md:text-xl font-black text-slate-800 leading-tight">Konya, Türkiye</p>
                                <p class="text-sm text-slate-500 font-medium italic break-words">
                                    <?php echo e($site_settings['address'] ?? 'Fevzi Çakmak Mh. Büsan Özel Organize Sanayi'); ?>

                                </p>
                            </div>
                        </div>
                    </div>

                    <div class="grid md:grid-cols-2 lg:grid-cols-1 gap-4 md:gap-6">
                        
                        <div class="glass p-6 md:p-10 rounded-[30px] md:rounded-[50px] border border-slate-200 shadow-xl group hover:bg-white transition-all duration-500">
                            <div class="flex items-center gap-4 md:gap-6">
                                <div class="w-12 h-12 md:w-14 md:h-14 rounded-2xl bg-green-50 text-[#3fae2a] flex items-center justify-center flex-shrink-0">
                                    <svg class="w-5 h-5 md:w-6 md:h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
                                </div>
                                <div class="min-w-0">
                                    <h4 class="text-[10px] md:text-xs font-black text-slate-400 uppercase tracking-widest">Bizi Arayın</h4>
                                    <a href="tel:<?php echo e($site_settings['phone'] ?? '#'); ?>" class="block text-lg md:text-xl font-black text-slate-800 hover:text-[#3fae2a] transition-colors tracking-tighter truncate">
                                        <?php echo e($site_settings['phone'] ?? '0212 000 00 00'); ?>

                                    </a>
                                </div>
                            </div>
                        </div>

                        
                        <div class="glass p-6 md:p-10 rounded-[30px] md:rounded-[50px] border border-slate-200 shadow-xl group hover:bg-white transition-all duration-500">
                            <div class="flex items-center gap-4 md:gap-6">
                                <div class="w-12 h-12 md:w-14 md:h-14 rounded-2xl bg-blue-50 text-blue-500 flex items-center justify-center flex-shrink-0">
                                    <svg class="w-5 h-5 md:w-6 md:h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 00-2 2z"></path></svg>
                                </div>
                                <div class="min-w-0 w-full">
                                    <h4 class="text-[10px] md:text-xs font-black text-slate-400 uppercase tracking-widest">E-Posta</h4>
                                    
                                    <a href="mailto:<?php echo e($site_settings['email'] ?? '#'); ?>" class="block text-lg md:text-xl font-black text-slate-800 hover:text-blue-500 transition-colors tracking-tighter lowercase break-all">
                                        <?php echo e($site_settings['email'] ?? 'info@azizusta.com'); ?>

                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    
                    <div class="glass-darker p-6 md:p-8 rounded-[30px] md:rounded-[40px] border border-slate-200 flex flex-col md:flex-row justify-between items-center gap-4 text-center md:text-left">
                        <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Sosyal Medyada Biz:</span>
                        <div class="flex gap-3">
                            <?php if(isset($site_settings['instagram'])): ?>
                                <a href="<?php echo e($site_settings['instagram']); ?>" target="_blank" class="w-10 h-10 rounded-xl bg-white border border-slate-100 flex items-center justify-center text-[#e31e23] hover:bg-[#e31e23] hover:text-white transition-all shadow-sm">
                                    <svg class="w-5 h-5 fill-current" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg>
                                </a>
                            <?php endif; ?>
                            <?php if(isset($site_settings['facebook'])): ?>
                                <a href="<?php echo e($site_settings['facebook']); ?>" target="_blank" class="w-10 h-10 rounded-xl bg-white border border-slate-100 flex items-center justify-center text-slate-800 hover:bg-slate-900 hover:text-white transition-all shadow-sm">
                                    <svg class="w-5 h-5 fill-current" viewBox="0 0 24 24"><path d="M9 8h-3v4h3v12h5v-12h3.642l.358-4h-4v-1.667c0-.955.192-1.333 1.115-1.333h2.885v-5h-3.808c-3.596 0-5.192 1.583-5.192 4.615v3.385z"/></svg>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                
                
                <div class="lg:col-span-7 glass rounded-[40px] md:rounded-[60px] p-6 md:p-16 border border-slate-200 shadow-2xl relative overflow-hidden bg-white/40">
                    <div class="relative z-10">
                        <h3 class="text-2xl md:text-3xl font-black text-slate-900 mb-2 italic">Hızlı Mesaj</h3>
                        <p class="text-slate-400 text-xs md:text-sm font-bold uppercase tracking-widest mb-6 md:mb-10">Bize her konuda yazabilirsiniz</p>

                        <?php if(session('success')): ?>
                            <div class="max-w-7xl mx-auto mb-10">
                                <div class="glass p-4 md:p-6 rounded-[30px] border-2 border-[#3fae2a]/30 bg-green-50/50 flex items-center gap-4 animate-bounce">
                                    <div class="w-8 h-8 md:w-10 md:h-10 bg-[#3fae2a] text-white rounded-full flex items-center justify-center flex-shrink-0 font-bold">✓</div>
                                    <p class="text-[#3fae2a] font-black text-xs md:text-sm uppercase tracking-wider"><?php echo e(session('success')); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>

                        <form action="<?php echo e(route('site.contact.post')); ?>" method="POST" class="grid md:grid-cols-2 gap-4 md:gap-6">
                            <?php echo csrf_field(); ?>
                            <div class="space-y-2">
                                <label class="text-[10px] font-black text-slate-500 uppercase tracking-widest ml-4">Adınız Soyadınız</label>
                                <input type="text" name="name" required placeholder="Örn: Ahmet Yılmaz" class="w-full bg-white/60 p-4 md:p-5 rounded-3xl border-2 border-slate-200 focus:border-[#3fae2a] focus:outline-none transition-all font-bold text-slate-700 text-sm md:text-base">
                            </div>
                            <div class="space-y-2">
                                <label class="text-[10px] font-black text-slate-500 uppercase tracking-widest ml-4">E-Posta Adresiniz</label>
                                <input type="email" name="email" required placeholder="ahmet@mail.com" class="w-full bg-white/60 p-4 md:p-5 rounded-3xl border-2 border-slate-200 focus:border-[#3fae2a] focus:outline-none transition-all font-bold text-slate-700 text-sm md:text-base">
                            </div>
                            <div class="md:col-span-2 space-y-2">
                                <label class="text-[10px] font-black text-slate-500 uppercase tracking-widest ml-4">Konu</label>
                                <input type="text" name="subject" required placeholder="Hangi konuda görüşmek istersiniz?" class="w-full bg-white/60 p-4 md:p-5 rounded-3xl border-2 border-slate-200 focus:border-[#3fae2a] focus:outline-none transition-all font-bold text-slate-700 text-sm md:text-base">
                            </div>
                            <div class="md:col-span-2 space-y-2">
                                <label class="text-[10px] font-black text-slate-500 uppercase tracking-widest ml-4">Mesajınız</label>
                                <textarea name="message" required rows="5" placeholder="Detaylı bilgi yazabilirsiniz..." class="w-full bg-white/60 p-6 md:p-8 rounded-[30px] md:rounded-[40px] border-2 border-slate-200 focus:border-[#3fae2a] focus:outline-none transition-all font-bold text-slate-700 resize-none text-sm md:text-base"></textarea>
                            </div>
                            <div class="md:col-span-2 pt-2 md:pt-4">
                                <button type="submit" class="w-full bg-[#3fae2a] text-white py-5 md:py-6 rounded-[24px] md:rounded-[32px] font-black text-xs uppercase tracking-[0.2em] md:tracking-[0.4em] shadow-xl hover:bg-slate-900 hover:shadow-none transition-all active:scale-95">
                                    Mesajımı Gönder
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

            </div>

            
            
            <div class="mt-6 md:mt-8 glass rounded-[40px] md:rounded-[60px] h-[300px] md:h-[400px] border border-slate-200 overflow-hidden relative group">
                <div class="absolute inset-0 bg-slate-100 flex items-center justify-center">
                    <iframe
                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d10000!2d32.5!3d37.9!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMzfCsDU0JzAwLjAiTiAzMsKwMzAnMDAuMCJF!5e0!3m2!1str!2str!4v123456789"
                            class="w-full h-full border-0 grayscale hover:grayscale-0 transition-all duration-700"
                            allowfullscreen="" loading="lazy">
                    </iframe>
                </div>
                <div class="absolute bottom-4 left-4 right-4 md:right-auto md:bottom-8 md:left-8 glass-darker px-6 py-4 md:px-8 md:py-6 rounded-[24px] md:rounded-[32px] border border-white shadow-2xl">
                    <h5 class="text-slate-800 font-black text-xs md:text-sm uppercase tracking-widest mb-1">Genel Merkez Lokasyonu</h5>
                    <p class="text-[9px] md:text-[10px] text-slate-400 font-bold uppercase italic"><?php echo e($site_settings['address'] ?? 'Konya • Türkiye'); ?></p>
                </div>
            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('site.pages.build', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/markamix/azizusta.markamix.tr/resources/views/site/pages/contact.blade.php ENDPATH**/ ?>