<nav class="fixed w-full z-50 top-6 px-6">
    <div class="max-w-6xl mx-auto glass rounded-full py-3 px-8 flex justify-between items-center border border-white/50 shadow-2xl">

        <a href="<?php echo e(route('site.index')); ?>" class="flex items-center gap-2">
            <?php if(isset($site_settings['logo'])): ?>
                <img src="<?php echo e(asset($site_settings['logo'])); ?>"
                     style="height: 5rem !important;"
                     alt="Aziz Usta Logo"
                     class="h-10 w-auto object-contain transition-transform hover:scale-105">
            <?php else: ?>
                <span class="font-black text-2xl tracking-tighter text-[#e31e23]">
                    AZİZ <span class="text-[#3fae2a]">USTA</span>
                </span>
            <?php endif; ?>
        </a>

        <div class="hidden lg:flex gap-2 items-center font-bold text-[13px] text-slate-600 uppercase tracking-wide">
            <a href="<?php echo e(route('site.index')); ?>" class="px-4 py-2 rounded-full hover:bg-white/50 hover:text-[#e31e23] transition-all">Ana Sayfa</a>

            
            <div class="relative group">
                <button class="flex items-center gap-1 px-4 py-2 rounded-full hover:bg-white/50 hover:text-[#e31e23] transition-all group">
                    Kurumsal
                    <svg class="w-4 h-4 transition-transform group-hover:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                </button>
                <div class="absolute top-full left-0 mt-2 w-64 glass-darker rounded-[32px] p-4 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 border border-white shadow-2xl translate-y-2 group-hover:translate-y-0">
                    <div class="flex flex-col gap-1">
                        <a href="<?php echo e(route('site.about')); ?>" class="px-5 py-3 rounded-2xl hover:bg-[#e31e23]/10 hover:text-[#e31e23] transition-colors">Biz Kimiz? <span class="block text-[9px] text-slate-400 lowercase italic">Hakkımızda, Misyon, Vizyon</span></a>
                        <a href="<?php echo e(route('site.quality')); ?>" class="px-5 py-3 rounded-2xl hover:bg-[#e31e23]/10 hover:text-[#e31e23] transition-colors">Kalite Politikamız</a>
                        <a href="<?php echo e(route('site.certificate')); ?>" class="px-5 py-3 rounded-2xl hover:bg-[#e31e23]/10 hover:text-[#e31e23] transition-colors">Sertifika ve Belgeler</a>
                    </div>
                </div>
            </div>

            <a href="<?php echo e(route('site.branches')); ?>" class="px-4 py-2 rounded-full hover:bg-white/50 hover:text-[#e31e23] transition-all">Bayilerimiz</a>

            <div class="relative group">
                <button class="flex items-center gap-1 px-4 py-2 rounded-full hover:bg-white/50 hover:text-[#3fae2a] transition-all group">
                    Franchise
                    <svg class="w-4 h-4 transition-transform group-hover:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                </button>
                <div class="absolute top-full left-0 mt-2 w-64 glass-darker rounded-[32px] p-4 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 border border-white shadow-2xl translate-y-2 group-hover:translate-y-0">
                    <div class="flex flex-col gap-1">
                        <a href="<?php echo e(route('site.why')); ?>" class="px-5 py-3 rounded-2xl hover:bg-[#3fae2a]/10 hover:text-[#3fae2a] transition-colors">Neden Aziz Usta?</a>
                        <a href="<?php echo e(route('site.requirements')); ?>" class="px-5 py-3 rounded-2xl hover:bg-[#3fae2a]/10 hover:text-[#3fae2a] transition-colors">Franchise Şartlarımız</a>
                        <a href="<?php echo e(route('site.application')); ?>" class="px-5 py-3 rounded-2xl hover:bg-[#3fae2a]/10 hover:text-[#3fae2a] transition-colors">Franchise Başvuru Formu</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="flex items-center gap-4">
            <a href="<?php echo e(route('site.contact')); ?>" class="hidden sm:block text-[11px] font-black text-slate-400 hover:text-slate-900 transition-colors tracking-widest uppercase">İletişim</a>

            <a href="tel:<?php echo e($site_settings['phone'] ?? '02120000000'); ?>" class="bg-[#3fae2a] text-white px-7 py-3 rounded-full text-xs font-black tracking-widest uppercase shadow-[0_10px_20px_-5px_rgba(63,174,42,0.4)] hover:scale-105 transition-all">
                Bizi Arayın
            </a>
        </div>
    </div>
</nav>
<?php /**PATH /Users/berke/PhpstormProjects/azizusta/resources/views/site/layouts/menu.blade.php ENDPATH**/ ?>