<footer class="relative pt-32 pb-12 px-6 overflow-hidden bg-[#fcfdfd]">

    <div class="absolute top-0 left-0 w-full h-px bg-gradient-to-r from-transparent via-slate-200 to-transparent"></div>
    <div class="absolute -top-24 left-1/4 w-96 h-96 bg-[#e31e23]/5 rounded-full blur-[100px] -z-10"></div>
    <div class="absolute bottom-0 right-1/4 w-96 h-96 bg-[#3fae2a]/5 rounded-full blur-[100px] -z-10"></div>

    <div class="max-w-7xl mx-auto">

        <div class="grid lg:grid-cols-12 gap-12 pb-20 border-b border-slate-100">
            <div class="lg:col-span-5 space-y-6">
                <div class="flex flex-col gap-1" style="align-items: baseline">
                    <?php if(isset($site_settings['logo'])): ?>
                        <img src="<?php echo e(asset($site_settings['logo'])); ?>" alt="Aziz Usta" style="height: 7rem !important;" class="h-12 w-auto object-contain mb-2">
                    <?php else: ?>
                        <span class="font-black text-4xl tracking-tighter text-[#e31e23]">AZİZ <span class="text-[#3fae2a]">USTA</span></span>
                    <?php endif; ?>
                    <span class="text-[10px] font-black text-slate-400 uppercase tracking-[0.5em]">Meşhur Adıyaman Çiğköftecisi</span>
                </div>
                <p class="text-slate-500 text-lg leading-relaxed max-w-md italic">
                    Adıyaman’ın geleneksel lezzet mirasını, Aziz Usta'nın ustalığıyla 100’e yakın şubemizde geleceğe taşıyoruz.
                </p>

                <div class="flex gap-3">
                    <?php if(isset($site_settings['instagram'])): ?>
                        <a href="<?php echo e($site_settings['instagram']); ?>" target="_blank" class="w-12 h-12 glass-darker rounded-2xl flex items-center justify-center hover:bg-[#e31e23] hover:text-white transition-all shadow-sm border border-white group">
                            <svg class="w-5 h-5 fill-current" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg>
                        </a>
                    <?php endif; ?>
                    <?php if(isset($site_settings['facebook'])): ?>
                        <a href="<?php echo e($site_settings['facebook']); ?>" target="_blank" class="w-12 h-12 glass-darker rounded-2xl flex items-center justify-center hover:bg-[#3fae2a] hover:text-white transition-all shadow-sm border border-white group">
                            <svg class="w-5 h-5 fill-current" viewBox="0 0 24 24"><path d="M9 8h-3v4h3v12h5v-12h3.642l.358-4h-4v-1.667c0-.955.192-1.333 1.115-1.333h2.885v-5h-3.808c-3.596 0-5.192 1.583-5.192 4.615v3.385z"/></svg>
                        </a>
                    <?php endif; ?>
                    <?php if(isset($site_settings['twitter'])): ?>
                        <a href="<?php echo e($site_settings['twitter']); ?>" target="_blank" class="w-12 h-12 glass-darker rounded-2xl flex items-center justify-center hover:bg-slate-900 hover:text-white transition-all shadow-sm border border-white group">
                            <svg class="w-5 h-5 fill-current" viewBox="0 0 24 24"><path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/></svg>
                        </a>
                    <?php endif; ?>
                </div>
            </div>

            <div class="lg:col-span-2 space-y-8">
                <h4 class="font-black text-slate-900 text-sm uppercase tracking-widest border-l-4 border-[#e31e23] pl-4">Hızlı Erişim</h4>
                <ul class="space-y-4 text-slate-500 text-sm font-bold">
                    <li><a href="<?php echo e(route('site.index')); ?>" class="hover:text-[#e31e23] transition-colors">Ana Sayfa</a></li>
                    <li><a href="<?php echo e(route('site.about')); ?>" class="hover:text-[#e31e23] transition-colors">Biz Kimiz?</a></li>
                    <li><a href="<?php echo e(route('site.certificate')); ?>" class="hover:text-[#e31e23] transition-colors">Sertifikalar</a></li>
                    <li><a href="<?php echo e(route('site.branches')); ?>" class="hover:text-[#e31e23] transition-colors">Bayilerimiz</a></li>
                </ul>
            </div>

            <div class="lg:col-span-2 space-y-8">
                <h4 class="font-black text-slate-900 text-sm uppercase tracking-widest border-l-4 border-[#3fae2a] pl-4">Franchise</h4>
                <ul class="space-y-4 text-slate-500 text-sm font-bold">
                    <li><a href="<?php echo e(route('site.why')); ?>" class="hover:text-[#3fae2a] transition-colors">Neden Aziz Usta?</a></li>
                    <li><a href="<?php echo e(route('site.requirements')); ?>" class="hover:text-[#3fae2a] transition-colors">Bayilik Şartları</a></li>
                    <li><a href="<?php echo e(route('site.application')); ?>" class="hover:text-[#3fae2a] transition-colors">Başvuru Formu</a></li>
                    <li><a href="<?php echo e(route('site.contact')); ?>" class="hover:text-[#3fae2a] transition-colors">İletişim</a></li>
                </ul>
            </div>

            <div class="lg:col-span-3 space-y-8 text-center lg:text-right">
                <h4 class="font-black text-slate-900 text-sm uppercase tracking-widest">Kalite Standartları</h4>
                <div class="flex justify-center lg:justify-end gap-3 flex-wrap">
                    <div class="w-16 h-16 glass rounded-2xl flex items-center justify-center border border-white p-2">
                        <span class="text-[8px] font-black text-center text-slate-400 leading-tight tracking-tighter uppercase">TSE <br> ONAYLI</span>
                    </div>
                    <div class="w-16 h-16 glass rounded-2xl flex items-center justify-center border border-white p-2">
                        <span class="text-[8px] font-black text-center text-[#3fae2a] leading-tight tracking-tighter uppercase">HELAL <br> GIDA</span>
                    </div>
                    <div class="w-16 h-16 glass rounded-2xl flex items-center justify-center border border-white p-2">
                        <span class="text-[8px] font-black text-center text-[#e31e23] leading-tight tracking-tighter uppercase">ISO <br> 9001</span>
                    </div>
                </div>
                <p class="text-[10px] text-slate-400 font-bold leading-relaxed mt-4 italic">Üretim tesislerimiz yüksek hijyen ve kalite standartlarına göre periyodik olarak denetlenmektedir.</p>
            </div>
        </div>

        <div class="grid md:grid-cols-3 gap-6 py-16">

            <div class="glass-darker p-8 rounded-[40px] border border-white flex items-center gap-6 group hover:bg-white transition-all duration-500">
                <div class="w-14 h-14 rounded-2xl bg-red-50 text-[#e31e23] flex items-center justify-center group-hover:bg-[#e31e23] group-hover:text-white transition-all">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
                </div>
                <div>
                    <span class="block text-[10px] font-black text-slate-400 uppercase tracking-widest mb-1">Müşteri Hattı</span>
                    <a href="tel:<?php echo e($site_settings['phone'] ?? '#'); ?>" class="text-xl font-black text-slate-900 leading-none hover:text-[#e31e23] transition-colors">
                        <?php echo e($site_settings['phone'] ?? '0212 000 00 00'); ?>

                    </a>
                </div>
            </div>

            <div class="glass-darker p-8 rounded-[40px] border border-white flex items-center gap-6 group hover:bg-white transition-all duration-500">
                <div class="w-14 h-14 rounded-2xl bg-green-50 text-[#3fae2a] flex items-center justify-center group-hover:bg-[#3fae2a] group-hover:text-white transition-all">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                </div>
                <div>
                    <span class="block text-[10px] font-black text-slate-400 uppercase tracking-widest mb-1">Genel Merkez</span>
                    <span class="text-xl font-black text-slate-900 leading-none tracking-tighter italic">
                        <?php echo e($site_settings['address'] ? Str::limit($site_settings['address'], 30) : 'Konya / Türkiye'); ?>

                    </span>
                </div>
            </div>

            <div class="glass-darker p-8 rounded-[40px] border border-white flex items-center gap-6 group hover:bg-white transition-all duration-500">
                <div class="w-14 h-14 rounded-2xl bg-slate-100 text-slate-600 flex items-center justify-center group-hover:bg-slate-900 group-hover:text-white transition-all">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 00-2 2z"></path></svg>
                </div>
                <div>
                    <span class="block text-[10px] font-black text-slate-400 uppercase tracking-widest mb-1">E-Posta</span>
                    <a href="mailto:<?php echo e($site_settings['email'] ?? '#'); ?>" class="text-xl font-black text-slate-900 leading-none lowercase hover:text-slate-500 transition-colors">
                        <?php echo e($site_settings['email'] ?? 'info@azizusta.com'); ?>

                    </a>
                </div>
            </div>

        </div>

        <div class="pt-8 border-t border-slate-100 flex flex-col md:flex-row justify-between items-center gap-6 text-center md:text-left">
            <div class="space-y-1">
                <p class="text-[10px] font-black text-slate-400 uppercase tracking-[0.3em]">
                    © <?php echo e(date('Y')); ?> MEŞHUR ADIYAMAN ÇİĞKÖFTECİSİ AZİZ USTA.
                </p>
                <p class="text-[9px] text-slate-300 font-bold uppercase tracking-[0.2em]">Bu bir Aziz Usta iştirakidir. Tüm hakları saklıdır.</p>
            </div>

        </div>
    </div>
</footer>
<?php /**PATH /Users/berke/PhpstormProjects/azizusta/resources/views/site/layouts/footer.blade.php ENDPATH**/ ?>