<?php $__env->startSection('content'); ?>
    <div class="space-y-8">

        <div class="flex flex-col md:flex-row md:items-end justify-between gap-6">
            <div>
                <h1 class="text-4xl font-black text-slate-900 tracking-tighter">Franchise <span class="text-[#e31e23]">Başvuruları</span></h1>
                <p class="text-slate-400 font-bold text-[10px] uppercase tracking-[0.3em] mt-2">Toplam <?php echo e($applications->count()); ?> Gelen Talep Bulunuyor</p>
            </div>

        </div>

        <div class="glass rounded-[40px] border border-white shadow-2xl overflow-hidden bg-white/40">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                    <tr class="bg-slate-50/50 border-b border-slate-100">
                        <th class="py-6 px-8 text-[10px] font-black uppercase text-slate-400 tracking-[0.2em]">Aday Bilgileri</th>
                        <th class="py-6 px-4 text-[10px] font-black uppercase text-slate-400 tracking-[0.2em]">Bölge Hedefi</th>
                        <th class="py-6 px-4 text-[10px] font-black uppercase text-slate-400 tracking-[0.2em]">İşletme Geçmişi</th>
                        <th class="py-6 px-4 text-[10px] font-black uppercase text-slate-400 tracking-[0.2em]">Başvuru Tarihi</th>
                        <th class="py-6 px-8 text-right text-[10px] font-black uppercase text-slate-400 tracking-[0.2em]">İşlemler</th>
                    </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-50">
                    <?php $__empty_1 = true; $__currentLoopData = $applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-white/80 transition-all group">
                            <td class="py-6 px-8">
                                <div class="flex items-center gap-4">
                                    <div class="w-10 h-10 rounded-full bg-slate-100 flex items-center justify-center text-slate-400 font-black text-xs group-hover:bg-[#e31e23] group-hover:text-white transition-colors">
                                        <?php echo e(substr($app->ad_soyad, 0, 1)); ?>

                                    </div>
                                    <div class="flex flex-col">
                                        <span class="text-sm font-black text-slate-800 tracking-tight"><?php echo e($app->ad_soyad); ?></span>
                                        <span class="text-[11px] font-bold text-slate-400"><?php echo e($app->email); ?></span>
                                        <span class="text-[11px] font-black text-[#3fae2a] mt-0.5"><?php echo e($app->telefon); ?></span>
                                    </div>
                                </div>
                            </td>

                            <td class="py-6 px-4">
                                <div class="flex items-center gap-2">
                                    <svg class="w-3 h-3 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path></svg>
                                    <span class="text-xs font-black text-slate-600 uppercase tracking-tighter italic"><?php echo e($app->lokasyon); ?></span>
                                </div>
                            </td>

                            <td class="py-6 px-4">
                                <?php if($app->deneyim == 'var'): ?>
                                    <span class="px-4 py-1.5 bg-green-50 text-[#3fae2a] rounded-xl text-[9px] font-black uppercase tracking-widest border border-[#3fae2a]/10">Deneyimli</span>
                                <?php else: ?>
                                    <span class="px-4 py-1.5 bg-slate-50 text-slate-400 rounded-xl text-[9px] font-black uppercase tracking-widest border border-slate-100">Deneyimsiz</span>
                                <?php endif; ?>
                            </td>

                            <td class="py-6 px-4">
                                <div class="flex flex-col">
                                    <span class="text-xs font-black text-slate-700 tracking-tighter"><?php echo e($app->created_at->translatedFormat('d F Y')); ?></span>
                                    <span class="text-[10px] font-bold text-slate-400 uppercase leading-none"><?php echo e($app->created_at->format('H:i')); ?></span>
                                </div>
                            </td>

                            <td class="py-6 px-8 text-right">
                                <div class="flex justify-end gap-2">
                                    
                                    <button
                                        onclick="openMessageModal('<?php echo e($app->ad_soyad); ?>', '<?php echo e(addslashes($app->mesaj ?? 'Mesaj bırakılmadı.')); ?>')"
                                        title="Mesajı Oku"
                                        class="w-10 h-10 glass-darker rounded-xl border border-slate-100 flex items-center justify-center text-slate-400 hover:text-[#3fae2a] hover:border-[#3fae2a] transition-all">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path></svg>
                                    </button>

                                    <a href="tel:<?php echo e($app->telefon); ?>" title="Hemen Ara" class="w-10 h-10 bg-slate-900 text-white rounded-xl flex items-center justify-center hover:bg-[#3fae2a] transition-all">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="py-32 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="w-20 h-20 bg-slate-50 rounded-full flex items-center justify-center mb-4 border border-slate-100">
                                        <svg class="w-8 h-8 text-slate-200" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"></path></svg>
                                    </div>
                                    <p class="text-slate-400 font-bold italic text-sm tracking-tight">Henüz kayıtlı bir franchise başvurusu bulunmuyor.</p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

    </div>

    <div id="messageModal" class="fixed inset-0 z-[100] hidden items-center justify-center px-4">
        <div class="absolute inset-0 bg-slate-900/40 backdrop-blur-md" onclick="closeMessageModal()"></div>

        <div class="relative glass rounded-[50px] w-full max-w-lg p-10 md:p-12 border border-white shadow-2xl animate-in fade-in zoom-in duration-300">
            <div class="flex justify-between items-start mb-8">
                <div>
                    <h4 class="text-[10px] font-black text-[#e31e23] uppercase tracking-[0.3em] mb-1">Aday Mesajı</h4>
                    <h3 id="modalUserName" class="text-2xl font-black text-slate-800 tracking-tighter italic">İsim Soyisim</h3>
                </div>
                <button onclick="closeMessageModal()" class="w-10 h-10 glass-darker rounded-full flex items-center justify-center text-slate-400 hover:text-slate-900 transition-colors">
                    ✕
                </button>
            </div>

            <div class="glass-darker p-8 rounded-[40px] border border-white shadow-inner">
                <p id="modalUserMessage" class="text-slate-600 font-medium leading-relaxed italic">
                    Mesaj buraya gelecek...
                </p>
            </div>

            <div class="mt-10">
                <button onclick="closeMessageModal()" class="w-full bg-slate-900 text-white py-5 rounded-[28px] font-black text-xs uppercase tracking-[0.4em] shadow-xl hover:bg-[#3fae2a] transition-all">
                    Anladım, Kapat
                </button>
            </div>
        </div>
    </div>
    <script>
        function openMessageModal(userName, message) {
            document.getElementById('modalUserName').innerText = userName;
            document.getElementById('modalUserMessage').innerText = message;

            const modal = document.getElementById('messageModal');
            modal.classList.remove('hidden');
            modal.classList.add('flex');
        }

        function closeMessageModal() {
            const modal = document.getElementById('messageModal');
            modal.classList.add('hidden');
            modal.classList.remove('flex');
        }

        // ESC tuşuyla kapatma
        window.addEventListener('keydown', (e) => {
            if (e.key === 'Escape') closeMessageModal();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.pages.build', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/markamix/azizusta.markamix.tr/resources/views/admin/applications/index.blade.php ENDPATH**/ ?>