<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Aziz Usta | Yönetim Paneli</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; background-color: #f8fafc; }
        .glass { background: rgba(255, 255, 255, 0.7); backdrop-filter: blur(20px); border: 1px solid rgba(255, 255, 255, 0.4); }
        .glass-darker { background: rgba(255, 255, 255, 0.9); backdrop-filter: blur(10px); }
        .active-menu { background: #e31e23; color: white; box-shadow: 0 10px 20px -5px rgba(227, 30, 35, 0.3); }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'asil-green': '#d70d0d',
                        'asil-dark': '#3a4b3a',
                    }
                }
            }
        }
    </script>
</head>
<body class="antialiased">

<aside class="fixed inset-y-0 left-0 w-72 m-6 hidden lg:block z-50">
    <div class="glass h-full rounded-[40px] flex flex-col p-8 shadow-2xl border border-white">
        <div class="mb-12 px-4">
            <span class="font-black text-2xl tracking-tighter text-[#e31e23]">AZİZ <span class="text-[#3fae2a]">USTA</span></span>
            <p class="text-[9px] font-bold text-slate-400 uppercase tracking-[0.3em] mt-1">Yönetim Merkezi</p>
        </div>

        <nav class="flex-1 space-y-2">
            <a href="<?php echo e(route('admin.applications.index')); ?>" class="flex items-center gap-4 px-6 py-4 rounded-2xl transition-all font-bold text-sm <?php echo e(request()->routeIs('admin.applications.*') ? 'active-menu' : 'text-slate-500 hover:bg-white'); ?>">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path></svg>
                Başvurular
            </a>

            <a href="<?php echo e(route('admin.messages.index')); ?>" class="flex items-center gap-4 px-6 py-4 rounded-2xl transition-all font-bold text-sm <?php echo e(request()->routeIs('admin.messages.*') ? 'active-menu' : 'text-slate-500 hover:bg-white'); ?>">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 00-2 2z"></path></svg>
                Gelen Mesajlar
            </a>

            
            <a href="<?php echo e(route('sliders.index')); ?>" class="flex items-center gap-4 px-6 py-4 rounded-2xl transition-all font-bold text-sm <?php echo e(request()->routeIs('admin.sliders.*') ? 'active-menu' : 'text-slate-500 hover:bg-white'); ?>">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                Slider Yönetimi
            </a>
            

            <a href="<?php echo e(route('branches.index')); ?>" class="flex items-center gap-4 px-6 py-4 rounded-2xl transition-all font-bold text-sm <?php echo e(request()->routeIs('branches.*') ? 'active-menu' : 'text-slate-500 hover:bg-white'); ?>">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path></svg>
                Bayi Yönetimi
            </a>

            <a href="<?php echo e(route('certificates.index')); ?>" class="flex items-center gap-4 px-6 py-4 rounded-2xl transition-all font-bold text-sm <?php echo e(request()->routeIs('certificates.*') ? 'active-menu' : 'text-slate-500 hover:bg-white'); ?>">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                Sertifikalar
            </a>

            <a href="<?php echo e(route('admin.settings')); ?>" class="flex items-center gap-4 px-6 py-4 rounded-2xl transition-all font-bold text-sm <?php echo e(request()->routeIs('admin.settings') ? 'active-menu' : 'text-slate-500 hover:bg-white'); ?>">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4"></path></svg>
                Ayarlar
            </a>
        </nav>

        <div class="pt-6 border-t border-white/50">
            <form action="<?php echo e(route('logout')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <button type="submit" class="flex items-center gap-4 px-6 py-4 w-full rounded-2xl text-red-500 font-bold text-sm hover:bg-red-50 transition-all">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path></svg>
                    Çıkış Yap
                </button>
            </form>
        </div>
    </div>
</aside>

<main class="lg:ml-80 min-h-screen p-6 lg:p-12">

    <header class="flex items-center justify-between mb-12">
        <div class="lg:hidden">
            <span class="font-black text-xl text-[#e31e23]">AZİZ <span class="text-[#3fae2a]">USTA</span></span>
        </div>

        <div class="hidden lg:block">
            <h2 class="text-slate-400 text-xs font-bold uppercase tracking-widest italic">Hoş Geldin, Yönetici</h2>
        </div>

        <div class="flex items-center gap-4">
            <div class="text-right hidden sm:block">
                <p class="text-sm font-black text-slate-800 leading-none">Admin Panel</p>
                <p class="text-[10px] font-bold text-[#3fae2a] uppercase mt-1">Sistem Çevrimiçi</p>
            </div>
            <div class="w-12 h-12 rounded-2xl glass border border-white flex items-center justify-center text-[#e31e23] font-black shadow-lg">
                A
            </div>
        </div>
    </header>

    <div class="relative z-10">
        <?php echo $__env->yieldContent('content'); ?>
    </div>

    <footer class="mt-20 pt-8 border-t border-slate-200/60 text-center lg:text-left">
        <p class="text-slate-400 text-[10px] font-bold uppercase tracking-widest">
            &copy; 2025 Aziz Usta Franchise Sistemi | Tüm Hakları Saklıdır.
        </p>
    </footer>
</main>

<div class="fixed top-0 right-0 w-[40%] h-[40%] bg-[#e31e23]/5 rounded-full blur-[120px] -z-10"></div>
<div class="fixed bottom-0 left-0 w-[40%] h-[40%] bg-[#3fae2a]/5 rounded-full blur-[120px] -z-10"></div>

</body>
</html>
<?php /**PATH /home/markamix/azizusta.markamix.tr/resources/views/admin/pages/build.blade.php ENDPATH**/ ?>