<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Aziz Usta | Yönetim Paneli Girişi</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200;0,800;1,200;1,800&display=swap" rel="stylesheet">

    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; }

        .glass {
            background: rgba(255, 255, 255, 0.7);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.4);
        }

        .glass-darker {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(10px);
            box-shadow: inset 0 2px 4px 0 rgba(0, 0, 0, 0.02);
        }

        .text-gradient-red {
            background: linear-gradient(to bottom right, #e31e23, #ff6b6b);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        /* Arka plan animasyonu */
        .blob {
            position: absolute;
            width: 500px;
            height: 500px;
            border-radius: 50%;
            filter: blur(120px);
            z-index: -1;
            animation: pulse 10s infinite alternate;
        }

        @keyframes pulse {
            from { transform: scale(1) translate(0, 0); opacity: 0.4; }
            to { transform: scale(1.2) translate(10%, 10%); opacity: 0.2; }
        }
    </style>
</head>
<body class="bg-[#f8fafc] overflow-hidden">

<div class="blob bg-[#e31e23]/10 top-[-10%] left-[-10%]"></div>
<div class="blob bg-[#3fae2a]/10 bottom-[-10%] right-[-10%]" style="animation-delay: 5s;"></div>

<main class="min-h-screen w-full flex items-center justify-center px-6">

    <div class="max-w-md w-full relative">

        <div class="absolute -top-12 left-1/2 -translate-x-1/2 w-24 h-24 glass rounded-[35px] shadow-2xl flex items-center justify-center z-20 border border-white rotate-3">
            <span class="text-4xl font-black italic text-[#e31e23]">A</span>
        </div>

        <div class="glass rounded-[60px] p-10 md:p-14 border border-white shadow-[0_32px_64px_-15px_rgba(0,0,0,0.1)] pt-20">

            <div class="text-center mb-10">
                <h1 class="font-black text-3xl tracking-tighter text-slate-900">
                    AZİZ <span class="text-[#3fae2a]">USTA</span>
                </h1>
                <div class="flex items-center justify-center gap-2 mt-2">
                    <span class="h-px w-4 bg-slate-200"></span>
                    <p class="text-slate-400 font-bold uppercase text-[9px] tracking-[0.4em]">Yönetim Paneli</p>
                    <span class="h-px w-4 bg-slate-200"></span>
                </div>
            </div>

            <?php if($errors->any()): ?>
                <div class="mb-4 p-4 rounded-2xl bg-red-50 text-red-600 text-xs font-bold border border-red-100">
                    <?php echo e($errors->first()); ?>

                </div>
            <?php endif; ?>

            <form action="<?php echo e(route('login')); ?>" method="POST" class="space-y-6">
                <?php echo csrf_field(); ?> 

                <div class="space-y-2">
                    <label class="text-[10px] font-black uppercase text-slate-500 ml-5 tracking-widest">Yönetici E-Posta</label>
                    <input type="email" name="email" value="<?php echo e(old('email')); ?>" required
                           class="glass-darker w-full px-8 py-5 rounded-[30px] border-2 border-slate-100 focus:border-[#e31e23] outline-none transition-all font-bold text-slate-700">
                </div>

                <div class="space-y-2">
                    <label class="text-[10px] font-black uppercase text-slate-500 ml-5 tracking-widest">Güvenli Şifre</label>
                    <input type="password" name="password" required
                           class="glass-darker w-full px-8 py-5 rounded-[30px] border-2 border-slate-100 focus:border-[#3fae2a] outline-none transition-all font-bold text-slate-700">
                </div>

                <div class="pt-4">
                    <button type="submit" class="w-full bg-slate-900 text-white py-6 rounded-[32px] font-black text-xs uppercase tracking-[0.4em] shadow-xl hover:bg-[#e31e23] transition-all">
                        Sisteme Giriş Yap
                    </button>
                </div>
            </form>
        </div>

        <p class="text-center mt-8 text-[10px] font-bold text-slate-400 uppercase tracking-widest">
            © 2025 Aziz Usta Veri Güvenliği Altyapısı
        </p>
    </div>
</main>

</body>
</html>
<?php /**PATH /home/markamix/azizusta.markamix.tr/resources/views/admin/auth/login.blade.php ENDPATH**/ ?>