<?php $__env->startSection('title', isset($slider) ? 'Slider Düzenle' : 'Yeni Slider'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-4xl mx-auto">
        <div class="bg-white rounded-lg shadow-sm border border-gray-200">

            
            <div class="px-6 py-4 border-b border-gray-200 bg-gray-50 rounded-t-lg">
                <h3 class="text-lg font-bold text-gray-800">
                    <?php echo e(isset($slider) ? 'Slider Düzenle' : 'Yeni Slider Ekle'); ?>

                </h3>
            </div>

            
            <div class="p-6">
                <form action="<?php echo e(isset($slider) ? route('sliders.update', $slider->id) : route('sliders.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php if(isset($slider)): ?> <?php echo method_field('PUT'); ?> <?php endif; ?>

                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

                        
                        <div class="col-span-1">
                            <label class="block mb-2 text-sm font-medium text-gray-900">Slider Görseli (Zorunlu)</label>
                            <input type="file" name="image"
                                   class="block w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 focus:outline-none file:mr-4 file:py-2 file:px-4 file:rounded-l-lg file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 transition">

                            <?php if(isset($slider)): ?>
                                <div class="mt-3 p-1 bg-white border border-gray-200 rounded-lg inline-block shadow-sm">
                                    <img src="<?php echo e(asset($slider->image)); ?>" class="h-32 w-auto object-cover rounded">
                                </div>
                            <?php endif; ?>
                        </div>

                        
                        <div class="col-span-1">
                            <label class="block mb-2 text-sm font-medium text-gray-900">Sıralama (Rank)</label>
                            <input type="number" name="rank"
                                   class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5"
                                   value="<?php echo e(old('rank', $slider->rank ?? 0)); ?>">
                        </div>

                        
                        <div class="col-span-1 md:col-span-2">
                            <label class="block mb-2 text-sm font-medium text-gray-900">Başlık (HTML Kullanılabilir)</label>

                            
                            <div class="flex items-center p-3 mb-3 text-sm text-blue-800 border border-blue-300 rounded-lg bg-blue-50" role="alert">
                                <svg class="flex-shrink-0 inline w-4 h-4 mr-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                                </svg>
                                <div>
                                    <span class="font-medium">İpucu:</span> Renkli yazı için örnek: <code class="bg-blue-100 text-blue-900 px-1 py-0.5 rounded font-mono text-xs">Adıyaman'ın &lt;span class="text-[#e31e23] italic"&gt;Has&lt;/span&gt; Lezzeti</code>
                                </div>
                            </div>

                            <textarea name="title" rows="3"
                                      class="block p-2.5 w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500 font-mono"><?php echo e(old('title', $slider->title ?? '')); ?></textarea>
                        </div>

                        
                        <div class="col-span-1 md:col-span-2">
                            <label class="block mb-2 text-sm font-medium text-gray-900">Alt Açıklama</label>
                            <input type="text" name="subtitle"
                                   class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5"
                                   value="<?php echo e(old('subtitle', $slider->subtitle ?? '')); ?>">
                        </div>

                        
                        <div class="col-span-1">
                            <label class="block mb-2 text-sm font-medium text-gray-900">Durum</label>
                            <select name="is_active" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5">
                                <option value="1" <?php echo e((old('is_active', $slider->is_active ?? 1) == 1) ? 'selected' : ''); ?>>Aktif</option>
                                <option value="0" <?php echo e((old('is_active', $slider->is_active ?? 1) == 0) ? 'selected' : ''); ?>>Pasif</option>
                            </select>
                        </div>

                    </div>

                    
                    <div class="mt-8 flex justify-end">
                        <button type="submit" class="text-white bg-green-600 hover:bg-green-700 focus:ring-4 focus:ring-green-300 font-bold rounded-lg text-sm px-8 py-3 mr-2 mb-2 focus:outline-none shadow-md transition-colors duration-200 flex items-center gap-2">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                            Kaydet
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.pages.build', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/markamix/azizusta.markamix.tr/resources/views/admin/sliders/form.blade.php ENDPATH**/ ?>