<?php $__env->startSection('title', 'Sertifika Yönetimi'); ?>

<?php $__env->startSection('content'); ?>
    <div class="w-full mx-auto">
        <div class="flex flex-col sm:flex-row justify-between items-center mb-6 bg-white p-4 rounded-lg shadow-sm border border-gray-100">
            <h3 class="text-xl font-bold text-gray-800">Sertifika Listesi</h3>
            <a href="<?php echo e(route('certificates.create')); ?>"
               class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition-colors duration-200 shadow-sm">
                + Yeni Ekle
            </a>
        </div>

        <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider w-16">#</th>
                        <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider w-32">Görsel</th>
                        <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">Başlık</th>
                        <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">Alt Başlık</th>
                        <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">Sıra</th>
                        <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">Durum</th>
                        <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider w-40">İşlem</th>
                    </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $certificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 text-sm text-gray-500"><?php echo e($cert->id); ?></td>
                            <td class="px-6 py-4">
                                <img class="h-16 w-12 object-cover rounded border border-gray-200" src="<?php echo e(asset($cert->image)); ?>">
                            </td>
                            <td class="px-6 py-4 text-sm font-medium text-gray-900"><?php echo e($cert->title); ?></td>
                            <td class="px-6 py-4 text-sm text-gray-500"><?php echo e($cert->subtitle); ?></td>
                            <td class="px-6 py-4 text-sm text-gray-700 font-bold"><?php echo e($cert->rank); ?></td>
                            <td class="px-6 py-4">
                                <?php if($cert->is_active): ?>
                                    <span class="px-2 py-1 text-xs font-medium bg-green-100 text-green-800 rounded-full border border-green-200">Aktif</span>
                                <?php else: ?>
                                    <span class="px-2 py-1 text-xs font-medium bg-red-100 text-red-800 rounded-full border border-red-200">Pasif</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4 flex gap-2">
                                <a href="<?php echo e(route('certificates.edit', $cert->id)); ?>" class="text-amber-600 bg-amber-50 px-3 py-1 rounded border border-amber-200 hover:bg-amber-100">Düzenle</a>
                                <form action="<?php echo e(route('certificates.destroy', $cert->id)); ?>" method="POST" onsubmit="return confirm('Silinsin mi?')">
                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="text-red-600 bg-red-50 px-3 py-1 rounded border border-red-200 hover:bg-red-100">Sil</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.pages.build', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/markamix/azizusta.markamix.tr/resources/views/admin/certificates/index.blade.php ENDPATH**/ ?>