<?php $__env->startSection('title', 'Şubelerimiz - Asilbey Hamsiköy Sütlacı'); ?>
<?php $__env->startPush('css'); ?>
    <style>
        /*! SVG Türkiye Haritası | CSS | MIT Lisans | dnomak.com */

        .svg-turkiye-haritasi {
            max-width: 1140px;
            margin: 0 auto;
            text-align: center;
        }
        .svg-turkiye-haritasi svg {
            width: 100%;
            height: auto;
        }
        .il-isimleri {
            position: absolute;
            z-index: 2;
        }
        .il-isimleri div {
            font-family: 'Open Sans';
            display: inline-block;
            background: #cc0606;
            color: #fff;
            padding: 8px 16px;
            -webkit-border-radius: 4px;
            -moz-border-radius: 4px;
            border-radius: 4px;
        }
        #svg-turkiye-haritasi path {
            cursor: pointer;
            fill: #222;
        }
        #svg-turkiye-haritasi path:hover {
            fill: #cc0606;
        }
        #guney-kibris {
            pointer-events: none;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

    <div x-data="mapController()" x-init="initMap()">

        <div class="fixed inset-0 pointer-events-none overflow-hidden -z-10">
            <div class="absolute top-0 left-0 w-[800px] h-[800px] bg-[#93ad7e] rounded-full mix-blend-multiply filter blur-[100px] opacity-10 animate-blob"></div>
            <div class="absolute bottom-0 right-0 w-[600px] h-[600px] bg-gray-200 rounded-full mix-blend-multiply filter blur-[100px] opacity-20 animate-blob animation-delay-2000"></div>
        </div>

        <section class="relative pt-40 pb-12 text-center">
            <div class="container mx-auto px-4 relative z-10">
                <span class="inline-block px-4 py-1.5 mb-4 text-xs font-bold tracking-[0.2em] text-[#93ad7e] border border-[#93ad7e]/30 rounded-full bg-white/60 backdrop-blur uppercase">
                    Lezzet Ağı
                </span>
                <h1 class="text-4xl md:text-6xl font-serif font-black text-[#3a4b3a] mb-6">
                    Bayilerimiz
                </h1>
                <p class="text-[#5e5f5f] text-lg max-w-2xl mx-auto font-light">
                    Türkiye genelindeki şube ve bayilerimizi harita üzerinden inceleyebilirsiniz.
                </p>
            </div>
        </section>

        <section class="pb-24 relative z-10">
            <div class="container mx-auto px-4">
                <div class="flex flex-col xl:flex-row gap-8 items-start">

                    <div class="w-full xl:w-8/12">
                        <div class="bg-white/50 backdrop-blur-xl rounded-[3rem] p-4 md:p-8 border border-white shadow-xl relative overflow-hidden">

                            <div class="w-full h-auto relative map-container">
                                <?php echo $__env->make('site.layouts.turkey-map-svg', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>

                            <div class="mt-6 flex items-center justify-center gap-6 text-xs font-bold text-gray-500">
                                <div class="flex items-center gap-2"><span class="w-3 h-3 rounded-full bg-[#93ad7e]"></span> Şube Var</div>
                                <div class="flex items-center gap-2"><span class="w-3 h-3 rounded-full bg-gray-200"></span> Henüz Yok</div>
                                <div class="flex items-center gap-2"><span class="w-3 h-3 rounded-full bg-[#3a4b3a]"></span> Seçili İl</div>
                            </div>
                        </div>
                    </div>

                    <div class="w-full xl:w-4/12">
                        <div class="bg-white/80 backdrop-blur-md rounded-[3rem] p-8 border border-white/60 shadow-lg min-h-[500px] flex flex-col">

                            <div x-show="!selectedCity" class="flex-1 flex flex-col items-center justify-center text-center p-6" x-transition>
                                <div class="w-20 h-20 bg-[#93ad7e]/10 rounded-full flex items-center justify-center text-[#93ad7e] text-3xl mb-6 animate-pulse">
                                    <i class="fa-solid fa-map-location-dot"></i>
                                </div>
                                <h3 class="text-2xl font-serif font-bold text-[#3a4b3a] mb-2">İl Seçiniz</h3>
                                <p class="text-[#5e5f5f] text-sm">
                                    Şubelerimizi ve satış noktalarımızı görüntülemek için harita üzerinden <strong class="text-[#93ad7e]">Yeşil</strong> renkli illere tıklayınız.
                                </p>
                            </div>

                            <div x-show="selectedCity" style="display: none;" x-transition>
                                <div class="flex items-center justify-between mb-6 pb-4 border-b border-gray-100">
                                    <h3 class="text-2xl font-serif font-bold text-[#3a4b3a]">
                                        <span x-text="selectedCityName"></span>
                                        <span class="text-sm font-sans font-normal text-gray-400 block mt-1">Şube & Noktalar</span>
                                    </h3>
                                    <button @click="resetMap()" class="w-8 h-8 rounded-full bg-gray-100 flex items-center justify-center text-gray-400 hover:bg-red-50 hover:text-red-500 transition">
                                        <i class="fa-solid fa-xmark"></i>
                                    </button>
                                </div>

                                <div class="space-y-4 overflow-y-auto max-h-[600px] pr-2 custom-scrollbar">
                                    <template x-for="branch in getCityBranches()" :key="branch.name">
                                        <div class="bg-white p-5 rounded-2xl border border-gray-100 shadow-sm hover:shadow-md transition group">
                                            <div class="flex justify-between items-start mb-2">
                                                <h4 class="font-bold text-[#3a4b3a]" x-text="branch.name"></h4>
                                                <span class="text-[10px] font-bold px-2 py-1 rounded bg-green-50 text-[#93ad7e]" x-text="branch.type"></span>
                                            </div>
                                            <p class="text-xs text-gray-500 mb-4 flex gap-2">
                                                <i class="fa-solid fa-location-dot mt-0.5 text-[#93ad7e]"></i>
                                                <span x-text="branch.address"></span>
                                            </p>

                                            <div class="flex gap-2">
                                                <a :href="'tel:' + branch.phone"
                                                   class="flex-1 py-2 rounded-lg bg-gray-50 text-gray-600 text-xs font-bold text-center hover:bg-[#3a4b3a] hover:text-white transition">
                                                    Ara
                                                </a>

                                                <a :href="branch.map_link ? branch.map_link : '#'"
                                                   target="_blank"
                                                   :class="branch.map_link ? 'bg-[#93ad7e] hover:bg-[#7a9665]' : 'bg-gray-200 cursor-not-allowed opacity-50'"
                                                   class="flex-1 py-2 rounded-lg text-white text-xs font-bold text-center transition">
                                                    <span x-show="branch.map_link">Yol Tarifi</span>
                                                    <span x-show="!branch.map_link">Konum Yok</span>
                                                </a>
                                            </div>
                                        </div>
                                    </template>

                                    <div x-show="getCityBranches().length === 0" class="text-center py-8">
                                        <p class="text-gray-400 text-sm">Bu ilde henüz listelenmiş şubemiz bulunmamaktadır.</p>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </section>

        <section class="py-16 bg-[#3a4b3a] relative overflow-hidden">
            <div class="absolute inset-0 opacity-10 bg-[url('https://www.transparenttextures.com/patterns/cubes.png')]"></div>
            <div class="container mx-auto px-4 relative z-10 text-center">
                <h2 class="text-3xl font-serif font-bold text-white mb-4">Sizin Şehrinizde Yok Muyuz?</h2>
                <p class="text-[#e4ede2] mb-8 font-light">Asilbey lezzetini şehrinize getiren ilk kişi siz olun, kârlı bir yatırıma adım atın.</p>
                <a href="<?php echo e(url('/franchise')); ?>" class="inline-flex items-center gap-2 bg-[#93ad7e] text-white px-8 py-4 rounded-full font-bold shadow-lg hover:bg-white hover:text-[#3a4b3a] transition duration-300">
                    Bayilik Başvurusu Yap
                    <i class="fa-solid fa-arrow-right"></i>
                </a>
            </div>
        </section>

    </div>

    <style>
        /* Harita Varsayılan Stilleri */
        #svg-turkiye-haritasi path {
            fill: #e5e7eb; /* Pasif (Gri) */
            stroke: #ffffff;
            stroke-width: 1.5;
            transition: all 0.3s ease;
            cursor: default;
        }

        /* Şube Olan İller (Yeşil) */
        #svg-turkiye-haritasi path.has-branch {
            fill: #93ad7e;
            cursor: pointer;
        }

        /* Hover Efekti (Sadece şube olanlarda) */
        #svg-turkiye-haritasi path.has-branch:hover {
            fill: #7a9665;
            filter: drop-shadow(0 4px 6px rgba(0,0,0,0.1));
            transform: translateY(-2px);
        }

        /* Seçili İl (Koyu Yeşil) */
        #svg-turkiye-haritasi path.active-city {
            fill: #3a4b3a !important;
            filter: drop-shadow(0 0 10px rgba(58, 75, 58, 0.3));
        }

        /* Özel Scrollbar */
        .custom-scrollbar::-webkit-scrollbar { width: 5px; }
        .custom-scrollbar::-webkit-scrollbar-track { background: transparent; }
        .custom-scrollbar::-webkit-scrollbar-thumb { background: #d1d5db; border-radius: 10px; }
        .custom-scrollbar::-webkit-scrollbar-thumb:hover { background: #93ad7e; }
    </style>


<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        function mapController() {
            return {
                selectedCity: null,
                selectedCityName: '',

                // PHP'den gelen veriyi JSON olarak Alpine.js'e aktarıyoruz
                branchData: <?php echo json_encode($branchData, 15, 512) ?>,

                initMap() {
                    const groups = document.querySelectorAll('#svg-turkiye-haritasi g > g');
                    groups.forEach(group => {
                        const plate = group.getAttribute('data-plakakodu');
                        const paths = group.querySelectorAll('path');

                        // Eğer bu ilde şube varsa rengini yeşil yap
                        if (this.branchData[plate]) {
                            paths.forEach(p => p.classList.add('has-branch'));
                            group.addEventListener('click', () => {
                                this.handleCityClick(plate, group.getAttribute('data-iladi'));
                            });
                        }
                    });
                },

                handleCityClick(plate, name) {
                    // Önceki seçili ilin class'ını temizle
                    document.querySelectorAll('.active-city').forEach(el => el.classList.remove('active-city'));

                    // Yeni seçilen ilin path'lerine active class ekle
                    const selectedGroup = document.querySelector(`g[data-plakakodu="${plate}"]`);
                    if(selectedGroup) {
                        selectedGroup.querySelectorAll('path').forEach(p => p.classList.add('active-city'));
                    }

                    // Datayı güncelle (Alpine reaktivitesi sayesinde sağ taraf güncellenir)
                    this.selectedCity = plate;
                    this.selectedCityName = name;
                },

                resetMap() {
                    this.selectedCity = null;
                    document.querySelectorAll('.active-city').forEach(el => el.classList.remove('active-city'));
                },

                getCityBranches() {
                    return this.selectedCity ? (this.branchData[this.selectedCity] || []) : [];
                }
            }
        }
    </script>
    <script>
        /*! SVG Türkiye Haritası | MIT Lisans | dnomak.com */

        function svgturkiyeharitasi() {
            const element = document.querySelector('#svg-turkiye-haritasi');

            element.addEventListener(
                'mouseover',
                function (event) {
                    if (event.target.tagName === 'path' && event.target.parentNode.id !== 'guney-kibris') {

                    }
                }
            );

            element.addEventListener(
                'mousemove',
                function (event) {

                }
            );

            element.addEventListener(
                'mouseout',
                function (event) {

                }
            );

            element.addEventListener(
                'click',
                function (event) {
                    if (event.target.tagName === 'path') {
                        const parent = event.target.parentNode;
                        const id = parent.getAttribute('id');

                        if (
                            id === 'guney-kibris'
                        ) {
                            return;
                        }

                        window.location.href = (
                            '#'
                            + id
                            + '-'
                            + parent.getAttribute('data-plakakodu')
                        );
                    }
                }
            );
        }
        svgturkiyeharitasi();
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('site.pages.build', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/berke/PhpstormProjects/azizusta/resources/views/site/pages/branches.blade.php ENDPATH**/ ?>