<?php $__env->startSection('content'); ?>
    <div class="max-w-5xl">
        <div class="mb-10">
            <h1 class="text-4xl font-black text-slate-900 tracking-tighter">Sistem <span class="text-[#3fae2a]">Ayarları</span></h1>
            <p class="text-slate-400 font-bold text-[10px] uppercase tracking-[0.3em] mt-2">Site Genel Bilgileri ve Sosyal Medya Yönetimi</p>
        </div>

        <?php if(session('success')): ?>
            <div class="mb-6 p-4 rounded-3xl bg-green-50 text-[#3fae2a] font-black text-xs uppercase tracking-widest border border-green-100 animate-pulse">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST" enctype="multipart/form-data" class="space-y-8">
            <?php echo csrf_field(); ?>

            <div class="glass rounded-[40px] p-10 border border-white shadow-xl bg-white/40">
                <div class="flex items-center gap-4 mb-8">
                <span class="w-10 h-10 rounded-2xl bg-red-50 text-[#e31e23] flex items-center justify-center shadow-sm">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                </span>
                    <h3 class="text-xl font-black text-slate-800 tracking-tight italic">Görsel Kimlik</h3>
                </div>

                <div class="grid md:grid-cols-2 gap-10">
                    <div class="space-y-4">
                        <label class="text-[10px] font-black uppercase text-slate-400 ml-4 tracking-widest">Site Logosu (PNG/SVG)</label>
                        <div class="glass-darker p-6 rounded-[30px] border-2 border-dashed border-slate-200 flex flex-col items-center gap-4">
                            <?php if(isset($settings['logo'])): ?>
                                <img src="<?php echo e(asset( $settings['logo'])); ?>" class="h-16 object-contain" alt="Logo">
                            <?php else: ?>
                                <div class="h-16 flex items-center justify-center italic font-black text-slate-300">LOGO YOK</div>
                            <?php endif; ?>
                            <input type="file" name="logo" class="text-xs font-bold text-slate-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-xs file:font-black file:bg-[#e31e23] file:text-white hover:file:bg-slate-900 cursor-pointer">
                        </div>
                    </div>
                    <div class="space-y-4">
                        <label class="text-[10px] font-black uppercase text-slate-400 ml-4 tracking-widest">Favicon (ICO/PNG)</label>
                        <div class="glass-darker p-6 rounded-[30px] border-2 border-dashed border-slate-200 flex flex-col items-center gap-4">
                            <div class="h-16 w-16 bg-white rounded-2xl shadow-inner flex items-center justify-center overflow-hidden">
                                <?php if(isset($settings['favicon'])): ?>
                                    <img src="<?php echo e(asset( $settings['favicon'])); ?>" class="w-8 h-8 object-contain" alt="Favicon">
                                <?php else: ?>
                                    <span class="text-2xl opacity-20">🎯</span>
                                <?php endif; ?>
                            </div>
                            <input type="file" name="favicon" class="text-xs font-bold text-slate-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-xs file:font-black file:bg-[#3fae2a] file:text-white hover:file:bg-slate-900 cursor-pointer">
                        </div>
                    </div>
                </div>
            </div>

            <div class="glass rounded-[40px] p-10 border border-white shadow-xl bg-white/40">
                <div class="flex items-center gap-4 mb-8">
                <span class="w-10 h-10 rounded-2xl bg-green-50 text-[#3fae2a] flex items-center justify-center shadow-sm">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 00-2 2z"></path></svg>
                </span>
                    <h3 class="text-xl font-black text-slate-800 tracking-tight italic">İletişim Bilgileri</h3>
                </div>

                <div class="grid md:grid-cols-2 gap-6">
                    <div class="space-y-2">
                        <label class="text-[10px] font-black uppercase text-slate-400 ml-4">Telefon Numarası</label>
                        <input type="text" name="phone" value="<?php echo e($settings['phone'] ?? ''); ?>" class="w-full glass-darker p-5 rounded-3xl border-2 border-slate-100 focus:border-[#3fae2a] outline-none transition-all font-bold text-slate-700">
                    </div>
                    <div class="space-y-2">
                        <label class="text-[10px] font-black uppercase text-slate-400 ml-4">E-Posta Adresi</label>
                        <input type="email" name="email" value="<?php echo e($settings['email'] ?? ''); ?>" class="w-full glass-darker p-5 rounded-3xl border-2 border-slate-100 focus:border-[#3fae2a] outline-none transition-all font-bold text-slate-700">
                    </div>
                    <div class="md:col-span-2 space-y-2">
                        <label class="text-[10px] font-black uppercase text-slate-400 ml-4">Adres (Genel Merkez)</label>
                        <textarea name="address" rows="3" class="w-full glass-darker p-5 rounded-[35px] border-2 border-slate-100 focus:border-[#3fae2a] outline-none transition-all font-bold text-slate-700 resize-none"><?php echo e($settings['address'] ?? ''); ?></textarea>
                    </div>
                </div>
            </div>

            <div class="glass rounded-[40px] p-10 border border-white shadow-xl bg-white/40">
                <div class="flex items-center gap-4 mb-8">
                <span class="w-10 h-10 rounded-2xl bg-blue-50 text-blue-500 flex items-center justify-center shadow-sm">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.826a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"></path></svg>
                </span>
                    <h3 class="text-xl font-black text-slate-800 tracking-tight italic">Sosyal Medya Linkleri</h3>
                </div>

                <div class="grid md:grid-cols-3 gap-6">
                    <div class="space-y-2">
                        <label class="text-[10px] font-black uppercase text-slate-400 ml-4 italic">Instagram</label>
                        <input type="text" name="instagram" value="<?php echo e($settings['instagram'] ?? ''); ?>" placeholder="https://..." class="w-full glass-darker p-4 rounded-2xl border-2 border-slate-100 focus:border-pink-400 outline-none font-bold text-slate-700 text-sm">
                    </div>
                    <div class="space-y-2">
                        <label class="text-[10px] font-black uppercase text-slate-400 ml-4 italic">Facebook</label>
                        <input type="text" name="facebook" value="<?php echo e($settings['facebook'] ?? ''); ?>" placeholder="https://..." class="w-full glass-darker p-4 rounded-2xl border-2 border-slate-100 focus:border-blue-600 outline-none font-bold text-slate-700 text-sm">
                    </div>
                    <div class="space-y-2">
                        <label class="text-[10px] font-black uppercase text-slate-400 ml-4 italic">X (Twitter)</label>
                        <input type="text" name="twitter" value="<?php echo e($settings['twitter'] ?? ''); ?>" placeholder="https://..." class="w-full glass-darker p-4 rounded-2xl border-2 border-slate-100 focus:border-slate-900 outline-none font-bold text-slate-700 text-sm">
                    </div>
                </div>
            </div>

            <div class="flex justify-end pt-6">
                <button type="submit" class="bg-slate-900 text-white px-16 py-6 rounded-[30px] font-black text-xs uppercase tracking-[0.4em] shadow-2xl hover:bg-[#3fae2a] transition-all transform active:scale-95">
                    Tüm Ayarları Kaydet
                </button>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.pages.build', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/berke/PhpstormProjects/azizusta/resources/views/admin/settings/index.blade.php ENDPATH**/ ?>