<?php $__env->startSection('header', 'Şube Yönetimi'); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden">
        <div class="p-6 border-b border-gray-100 flex justify-between items-center">
            <h3 class="font-bold text-gray-700">Tüm Şube ve Satış Noktaları</h3>
            <a href="<?php echo e(route('branches.create')); ?>" class="bg-[#3a4b3a] hover:bg-[#93ad7e] text-white px-5 py-2.5 rounded-xl text-sm font-bold transition flex items-center gap-2">
                <i class="fa-solid fa-plus"></i> Yeni Şube Ekle
            </a>
        </div>

        <div class="overflow-x-auto">
            <table class="w-full text-left text-sm text-gray-600">
                <thead class="bg-gray-50 text-gray-800 font-bold uppercase text-xs">
                <tr>
                    <th class="px-6 py-4">İl</th>
                    <th class="px-6 py-4">Şube Adı</th>
                    <th class="px-6 py-4">Tür</th>
                    <th class="px-6 py-4">Telefon</th>
                    <th class="px-6 py-4">Durum</th>
                    <th class="px-6 py-4 text-right">İşlem</th>
                </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50 transition">
                        <td class="px-6 py-4 font-bold text-asil-green"><?php echo e($branch->city_plate); ?> - <?php echo e($branch->city_name); ?></td>
                        <td class="px-6 py-4 text-asil-dark"><?php echo e($branch->name); ?></td>
                        <td class="px-6 py-4"><span class="bg-gray-100 px-2 py-1 rounded text-[10px]"><?php echo e($branch->type); ?></span></td>
                        <td class="px-6 py-4 text-xs"><?php echo e($branch->phone); ?></td>
                        <td class="px-6 py-4">
                        <span class="px-2 py-1 rounded text-[10px] font-bold <?php echo e($branch->is_active ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700'); ?>">
                            <?php echo e($branch->is_active ? 'AKTİF' : 'PASİF'); ?>

                        </span>
                        </td>
                        <td class="px-6 py-4 text-right flex justify-end gap-2">
                            <a href="<?php echo e(route('branches.edit', $branch->id)); ?>" class="w-8 h-8 rounded-lg bg-blue-50 text-blue-600 flex items-center justify-center hover:bg-blue-600 hover:text-white transition">
                                <i class="fa-solid fa-pen"></i>
                            </a>
                            <form action="<?php echo e(route('branches.destroy', $branch->id)); ?>" method="POST" onsubmit="return confirm('Şubeyi silmek istediğinize emin misiniz?')">
                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                <button class="w-8 h-8 rounded-lg bg-red-50 text-red-500 flex items-center justify-center hover:bg-red-500 hover:text-white transition">
                                    <i class="fa-solid fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.pages.build', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/berke/PhpstormProjects/azizusta/resources/views/admin/branches/index.blade.php ENDPATH**/ ?>