<?php $__env->startSection('title', 'Franchise Şartlarımız'); ?>
<?php $__env->startSection('content'); ?>

    <section class="relative min-h-screen w-full bg-[#f8fafc] pt-44 pb-32 px-6 overflow-hidden">

        <div class="absolute top-[-10%] right-[-10%] w-[40rem] h-[40rem] bg-[#3fae2a]/5 rounded-full blur-[120px] -z-10 animate-pulse"></div>
        <div class="absolute bottom-[-10%] left-[-10%] w-[40rem] h-[40rem] bg-[#e31e23]/5 rounded-full blur-[120px] -z-10 animate-pulse"></div>

        <div class="max-w-7xl mx-auto relative z-10">

            <div class="grid lg:grid-cols-12 gap-8 mb-8">
                <div class="lg:col-span-7 glass rounded-[50px] p-12 md:p-16 border border-white flex flex-col justify-center">
                    <div class="inline-flex items-center gap-2 mb-6">
                        <span class="w-12 h-[2px] bg-[#e31e23]"></span>
                        <span class="text-[#e31e23] font-black uppercase text-xs tracking-widest">İş Ortaklığı Modeli</span>
                    </div>
                    <h1 class="text-5xl md:text-7xl font-black text-slate-900 tracking-tighter mb-8 leading-[0.9]">
                        Franchise <br><span class="text-[#3fae2a]">Şartlarımız</span>
                    </h1>
                    <p class="text-slate-500 text-lg font-medium leading-relaxed">
                        Aziz Usta standartlarını korumak ve başarılı bir işletme yönetmek için belirlediğimiz temel kriterler aşağıdadır. Bizim için en önemli şart; <span class="text-slate-900 font-bold italic">lezzet tutkusu ve girişimci ruhudur.</span>
                    </p>
                </div>

                <div class="lg:col-span-5 glass-darker rounded-[50px] p-12 border border-white shadow-2xl relative overflow-hidden group">
                    <div class="absolute -right-10 -top-10 w-40 h-40 bg-[#3fae2a]/10 rounded-full blur-3xl group-hover:bg-[#3fae2a]/20 transition-all"></div>
                    <h3 class="text-xl font-black text-slate-800 mb-8 border-b border-slate-100 pb-4 italic">Genel Bakış</h3>
                    <ul class="space-y-6">
                        <li class="flex items-center gap-4">
                            <div class="w-8 h-8 rounded-full bg-green-50 flex items-center justify-center text-[#3fae2a]">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"></path></svg>
                            </div>
                            <span class="text-sm font-bold text-slate-600 tracking-tight">Kendi İşinin Patronu Olma İsteği</span>
                        </li>
                        <li class="flex items-center gap-4">
                            <div class="w-8 h-8 rounded-full bg-green-50 flex items-center justify-center text-[#3fae2a]">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"></path></svg>
                            </div>
                            <span class="text-sm font-bold text-slate-600 tracking-tight">Eğitime ve Gelişime Açıklık</span>
                        </li>
                        <li class="flex items-center gap-4">
                            <div class="w-8 h-8 rounded-full bg-red-50 flex items-center justify-center text-[#e31e23]">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"></path></svg>
                            </div>
                            <span class="text-sm font-bold text-slate-600 tracking-tight">Marka Değerlerine Bağlılık</span>
                        </li>
                    </ul>
                </div>
            </div>

            <div class="grid md:grid-cols-3 gap-8 mb-8">
                <div class="glass p-12 rounded-[50px] border border-white hover:bg-white transition-all duration-500 group shadow-lg shadow-slate-200/50">
                    <div class="w-16 h-16 bg-slate-50 text-[#e31e23] rounded-[24px] flex items-center justify-center mb-8 group-hover:rotate-6 transition-transform">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                    </div>
                    <h3 class="text-xl font-black text-slate-800 mb-4 tracking-tight uppercase">1. Lokasyon Kriteri</h3>
                    <p class="text-sm text-slate-500 font-medium leading-relaxed">
                        Şubelerimiz yaya ve araç trafiğinin yoğun olduğu ana caddelerde, okul veya alışveriş merkezlerine yakın lokasyonlarda olmalıdır.
                    </p>
                </div>

                <div class="glass p-12 rounded-[50px] border border-white hover:bg-white transition-all duration-500 group shadow-lg shadow-slate-200/50">
                    <div class="w-16 h-16 bg-slate-50 text-[#3fae2a] rounded-[24px] flex items-center justify-center mb-8 group-hover:rotate-6 transition-transform">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path></svg>
                    </div>
                    <h3 class="text-xl font-black text-slate-800 mb-4 tracking-tight uppercase">2. Mağaza Konsepti</h3>
                    <p class="text-sm text-slate-500 font-medium leading-relaxed">
                        Kurumsal kimliğimize uygun dekorasyon ve Aziz Usta standartlarında iç mimari uygulama tüm bayilerimiz için zorunludur.
                    </p>
                </div>

                <div class="glass p-12 rounded-[50px] border border-white hover:bg-white transition-all duration-500 group shadow-lg shadow-slate-200/50">
                    <div class="w-16 h-16 bg-slate-50 text-blue-500 rounded-[24px] flex items-center justify-center mb-8 group-hover:rotate-6 transition-transform">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12.75L11.25 15 15 9.75m-3-7.036A11.959 11.959 0 013.598 6 11.99 11.99 0 003 9.749c0 5.592 3.824 10.29 9 11.623 5.176-1.333 9-6.03 9-11.622 0-1.31-.21-2.571-.598-3.751A11.956 11.956 0 0112 2.714z"></path></svg>
                    </div>
                    <h3 class="text-xl font-black text-slate-800 mb-4 tracking-tight uppercase">3. Operasyonel Şartlar</h3>
                    <p class="text-sm text-slate-500 font-medium leading-relaxed">
                        Ürünlerin tamamı merkezden tedarik edilir. Müşteri memnuniyeti ve hijyen kuralları işletme süresince birincil önceliğimizdir.
                    </p>
                </div>
            </div>

            <div class="relative group">
                <div class="absolute -inset-1 bg-gradient-to-r from-[#e31e23]/20 to-[#3fae2a]/20 rounded-[60px] blur-lg"></div>
                <div class="relative glass rounded-[60px] p-12 md:p-20 border border-white text-center">
                    <h4 class="text-3xl md:text-5xl font-black text-slate-900 italic mb-10 leading-tight">
                        Tüm şartları konuşmak ve <br class="hidden md:block"> <span class="text-[#e31e23]">detaylı sunum</span> almak için bize ulaşın.
                    </h4>

                    <div class="flex flex-col sm:flex-row items-center justify-center gap-6">
                        
                        <a href="<?php echo e(route('site.application')); ?>" class="bg-slate-900 text-white px-12 py-6 rounded-full font-black text-xs uppercase tracking-[0.4em] shadow-2xl hover:scale-105 transition-all">
                            Başvuru Formuna Git
                        </a>
                        <div class="flex flex-col items-center sm:items-start">
                            <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest mb-1">Doğrudan Destek Hattı</span>
                            
                            <a href="tel:<?php echo e($site_settings['phone'] ?? '02120000000'); ?>" class="text-xl font-black text-[#3fae2a] hover:text-[#e31e23] transition-colors tracking-tighter italic">
                                <?php echo e($site_settings['phone'] ?? '0212 000 00 00'); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.pages.build', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/markamix/azizusta.markamix.tr/resources/views/site/pages/requirements.blade.php ENDPATH**/ ?>