<?php $__env->startSection('title', 'Şubelerimiz - Meşhur Adıyaman Çiğköftecisi Aziz Usta'); ?>
<?php $__env->startPush('css'); ?>
    <style>
        /*! SVG Türkiye Haritası Stilleri */
        .svg-turkiye-haritasi {
            max-width: 1140px;
            margin: 0 auto;
            text-align: center;
        }
        .svg-turkiye-haritasi svg {
            width: 100%;
            height: auto;
        }
        /* Harita Varsayılanları */
        #svg-turkiye-haritasi path {
            fill: #e2e8f0; /* Slate-200 */
            stroke: #ffffff;
            stroke-width: 1.5;
            transition: all 0.3s ease;
            cursor: default;
        }

        /* Şube Olan İller (AZİZ USTA KIRMIZI) */
        #svg-turkiye-haritasi path.has-branch {
            fill: #e31e23;
            cursor: pointer;
        }

        /* Hover Efekti */
        #svg-turkiye-haritasi path.has-branch:hover {
            fill: #c4181c; /* Biraz daha koyu kırmızı */
            filter: drop-shadow(0 4px 6px rgba(227, 30, 35, 0.3));
            transform: translateY(-2px);
        }

        /* Seçili İl (AZİZ USTA YEŞİL) */
        #svg-turkiye-haritasi path.active-city {
            fill: #3fae2a !important;
            filter: drop-shadow(0 0 15px rgba(63, 174, 42, 0.4));
            z-index: 10;
            position: relative;
        }

        #guney-kibris { pointer-events: none; }

        /* Özel Scrollbar */
        .custom-scrollbar::-webkit-scrollbar { width: 5px; }
        .custom-scrollbar::-webkit-scrollbar-track { background: transparent; }
        .custom-scrollbar::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 10px; }
        .custom-scrollbar::-webkit-scrollbar-thumb:hover { background: #e31e23; }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <div x-data="mapController()" x-init="initMap()">

        
        <div class="fixed inset-0 pointer-events-none overflow-hidden -z-10">
            <div class="absolute top-0 left-0 w-[800px] h-[800px] bg-[#e31e23] rounded-full mix-blend-multiply filter blur-[120px] opacity-[0.08] animate-blob"></div>
            <div class="absolute bottom-0 right-0 w-[600px] h-[600px] bg-[#3fae2a] rounded-full mix-blend-multiply filter blur-[120px] opacity-[0.1] animate-blob animation-delay-2000"></div>
        </div>

        <section class="relative pt-40 pb-12 text-center">
            <div class="container mx-auto px-4 relative z-10">
                <span class="inline-block px-4 py-1.5 mb-4 text-xs font-bold tracking-[0.2em] text-[#e31e23] border border-[#e31e23]/20 rounded-full bg-white/60 backdrop-blur uppercase">
                    Lezzet Ağı
                </span>
                <h1 class="text-4xl md:text-6xl font-black text-slate-800 mb-6 tracking-tight">
                    Bayilerimiz
                </h1>
                <p class="text-slate-500 text-lg max-w-2xl mx-auto font-medium">
                    Türkiye genelindeki şube ve bayilerimizi harita üzerinden inceleyebilirsiniz.
                </p>
            </div>
        </section>

        <section class="pb-24 relative z-10">
            <div class="container mx-auto px-4">
                <div class="flex flex-col xl:flex-row gap-8 items-start">

                    
                    <div class="w-full xl:w-8/12">
                        <div class="bg-white/50 backdrop-blur-xl rounded-[3rem] p-4 md:p-8 border border-white shadow-xl relative overflow-hidden group hover:shadow-2xl transition-all duration-500">

                            <div class="w-full h-auto relative map-container">
                                <?php echo $__env->make('site.layouts.turkey-map-svg', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>

                            
                            <div class="mt-6 flex flex-wrap items-center justify-center gap-4 md:gap-6 text-xs font-bold text-slate-500">
                                <div class="flex items-center gap-2">
                                    <span class="w-3 h-3 rounded-full bg-[#e31e23] shadow-[0_0_10px_rgba(227,30,35,0.5)]"></span>
                                    Şube Var
                                </div>
                                <div class="flex items-center gap-2">
                                    <span class="w-3 h-3 rounded-full bg-slate-200"></span>
                                    Henüz Yok
                                </div>
                                <div class="flex items-center gap-2">
                                    <span class="w-3 h-3 rounded-full bg-[#3fae2a] shadow-[0_0_10px_rgba(63,174,42,0.5)]"></span>
                                    Seçili İl
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="w-full xl:w-4/12">
                        <div class="bg-white/80 backdrop-blur-md rounded-[3rem] p-8 border border-white/60 shadow-lg min-h-[500px] flex flex-col relative overflow-hidden">

                            
                            <div class="absolute top-0 right-0 w-32 h-32 bg-gradient-to-br from-red-500/5 to-transparent rounded-bl-full pointer-events-none"></div>

                            
                            <div x-show="!selectedCity" class="flex-1 flex flex-col items-center justify-center text-center p-6" x-transition>
                                <div class="w-24 h-24 bg-red-50 rounded-full flex items-center justify-center text-[#e31e23] text-4xl mb-6 animate-pulse ring-4 ring-red-50">
                                    <i class="fa-solid fa-map-location-dot"></i>
                                </div>
                                <h3 class="text-2xl font-bold text-slate-800 mb-2">İl Seçiniz</h3>
                                <p class="text-slate-500 text-sm leading-relaxed">
                                    Şubelerimizi görüntülemek için harita üzerindeki <strong class="text-[#e31e23]">Kırmızı</strong> renkli illere tıklayınız.
                                </p>
                            </div>

                            
                            <div x-show="selectedCity" style="display: none;" x-transition>
                                <div class="flex items-center justify-between mb-6 pb-4 border-b border-slate-100">
                                    <h3 class="text-2xl font-bold text-slate-800">
                                        <span x-text="selectedCityName"></span>
                                        <span class="text-xs font-semibold text-[#e31e23] bg-red-50 px-2 py-1 rounded ml-2 align-middle">Şubeler</span>
                                    </h3>
                                    <button @click="resetMap()" class="w-8 h-8 rounded-full bg-slate-100 flex items-center justify-center text-slate-400 hover:bg-[#e31e23] hover:text-white transition-colors duration-300">
                                        <i class="fa-solid fa-xmark"></i>
                                    </button>
                                </div>

                                <div class="space-y-4 overflow-y-auto max-h-[600px] pr-2 custom-scrollbar">
                                    <template x-for="branch in getCityBranches()" :key="branch.name">
                                        <div class="bg-white p-5 rounded-2xl border border-slate-100 shadow-sm hover:shadow-md hover:border-red-100 transition group relative overflow-hidden">

                                            
                                            <div class="absolute top-0 left-0 w-1 h-full bg-[#e31e23] opacity-0 group-hover:opacity-100 transition-opacity"></div>

                                            <div class="flex justify-between items-start mb-2 pl-2">
                                                <h4 class="font-bold text-slate-800 text-sm md:text-base" x-text="branch.name"></h4>

                                            </div>

                                            <p class="text-xs text-slate-500 mb-4 flex gap-2 pl-2">
                                                <i class="fa-solid fa-location-dot mt-0.5 text-[#e31e23]"></i>
                                                <span x-text="branch.address" class="line-clamp-2"></span>
                                            </p>

                                            <div class="flex flex-col md:flex-row gap-2 pl-2"> 

                                                
                                                <a :href="'tel:' + branch.phone"
                                                   class="flex-1 py-2.5 rounded-xl border border-[#e31e23]/20 text-[#e31e23] text-xs font-bold text-center hover:bg-[#e31e23] hover:text-white transition-all duration-300 flex items-center justify-center gap-1">
                                                    <i class="fa-solid fa-phone"></i>
                                                    <span>Ara:</span>
                                                    <span x-text="branch.phone"></span>
                                                </a>

                                                
                                                <a :href="branch.map_link ? branch.map_link : '#'"
                                                   target="_blank"
                                                   :class="branch.map_link ? 'bg-[#3fae2a] hover:bg-[#349622] text-white shadow-lg shadow-green-200' : 'bg-slate-100 text-slate-400 cursor-not-allowed'"
                                                   class="flex-1 py-2.5 rounded-xl text-xs font-bold text-center transition-all duration-300 flex items-center justify-center gap-1">
                <span x-show="branch.map_link" class="flex items-center gap-1">
                    <i class="fa-solid fa-diamond-turn-right"></i> Yol Tarifi
                </span>
                                                    <span x-show="!branch.map_link">Konum Yok</span>
                                                </a>
                                            </div>
                                        </div>
                                    </template>

                                    <div x-show="getCityBranches().length === 0" class="text-center py-10">
                                        <div class="text-slate-300 mb-2 text-4xl"><i class="fa-solid fa-store-slash"></i></div>
                                        <p class="text-slate-400 text-sm">Bu ilde henüz listelenmiş şubemiz bulunmamaktadır.</p>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </section>

        
        <section class="py-20 bg-[#e31e23] relative overflow-hidden">
            
            <div class="absolute inset-0 opacity-10 bg-[url('https://www.transparenttextures.com/patterns/cubes.png')]"></div>
            
            <div class="absolute -top-24 -left-24 w-96 h-96 bg-white opacity-10 rounded-full blur-[100px]"></div>

            <div class="container mx-auto px-4 relative z-10 text-center">
                <h2 class="text-3xl md:text-4xl font-black text-white mb-4">Sizin Şehrinizde Yok Muyuz?</h2>
                <p class="text-white/90 mb-8 font-medium text-lg max-w-2xl mx-auto">Aziz Usta'nın eşsiz lezzetini şehrinize getiren ilk kişi siz olun, kârlı ve prestijli bir yatırıma adım atın.</p>

                <a href="<?php echo e(url('/basvuru-formu')); ?>" class="group inline-flex items-center gap-3 bg-white text-[#e31e23] px-10 py-5 rounded-full font-bold text-lg shadow-2xl hover:bg-[#3fae2a] hover:text-white transition-all duration-300 transform hover:-translate-y-1">
                    <span>Bayilik Başvurusu Yap</span>
                    <i class="fa-solid fa-arrow-right group-hover:translate-x-1 transition-transform"></i>
                </a>
            </div>
        </section>

    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        function mapController() {
            return {
                selectedCity: null,
                selectedCityName: '',
                branchData: <?php echo json_encode($branchData, 15, 512) ?>,

                initMap() {
                    const groups = document.querySelectorAll('#svg-turkiye-haritasi g > g');
                    groups.forEach(group => {
                        const plate = group.getAttribute('data-plakakodu');
                        const paths = group.querySelectorAll('path');

                        // Veride bu plaka varsa 'has-branch' class'ı ekle
                        if (this.branchData[plate]) {
                            paths.forEach(p => p.classList.add('has-branch'));
                            group.addEventListener('click', () => {
                                this.handleCityClick(plate, group.getAttribute('data-iladi'));
                            });
                        }
                    });
                },

                handleCityClick(plate, name) {
                    // Önceki seçimi temizle
                    document.querySelectorAll('.active-city').forEach(el => el.classList.remove('active-city'));

                    // Yeni seçimi işaretle
                    const selectedGroup = document.querySelector(`g[data-plakakodu="${plate}"]`);
                    if(selectedGroup) {
                        selectedGroup.querySelectorAll('path').forEach(p => p.classList.add('active-city'));
                    }

                    this.selectedCity = plate;
                    this.selectedCityName = name;
                },

                resetMap() {
                    this.selectedCity = null;
                    document.querySelectorAll('.active-city').forEach(el => el.classList.remove('active-city'));
                },

                getCityBranches() {
                    return this.selectedCity ? (this.branchData[this.selectedCity] || []) : [];
                }
            }
        }
    </script>
    
    <script>
        /*! SVG Türkiye Haritası | MIT Lisans | dnomak.com */

        function svgturkiyeharitasi() {
            const element = document.querySelector('#svg-turkiye-haritasi');

            element.addEventListener(
                'mouseover',
                function (event) {
                    if (event.target.tagName === 'path' && event.target.parentNode.id !== 'guney-kibris') {

                    }
                }
            );

            element.addEventListener(
                'mousemove',
                function (event) {

                }
            );

            element.addEventListener(
                'mouseout',
                function (event) {

                }
            );

            element.addEventListener(
                'click',
                function (event) {
                    if (event.target.tagName === 'path') {
                        const parent = event.target.parentNode;
                        const id = parent.getAttribute('id');

                        if (
                            id === 'guney-kibris'
                        ) {
                            return;
                        }

                        window.location.href = (
                            '#'
                            + id
                            + '-'
                            + parent.getAttribute('data-plakakodu')
                        );
                    }
                }
            );
        }
        svgturkiyeharitasi();
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('site.pages.build', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/markamix/azizusta.markamix.tr/resources/views/site/pages/branches.blade.php ENDPATH**/ ?>