<?php $__env->startSection('title', 'Franchise Başvuru Formu'); ?>
<?php $__env->startSection('content'); ?>

    <section class="relative min-h-screen w-full bg-[#f8fafc] pt-44 pb-32 px-6 overflow-hidden">
        
        <div class="absolute top-[-10%] left-[-10%] w-[50rem] h-[50rem] bg-[#e31e23]/5 rounded-full blur-[120px] -z-10 animate-pulse"></div>
        <div class="absolute bottom-[-10%] right-[-10%] w-[50rem] h-[50rem] bg-[#3fae2a]/5 rounded-full blur-[120px] -z-10 animate-pulse"></div>

        <div class="max-w-5xl mx-auto relative z-10">

            
            <?php if(session('success')): ?>
                <div class="mb-10 animate-in fade-in slide-in-from-top duration-500">
                    <div class="glass border-2 border-[#3fae2a]/30 bg-green-50/50 p-6 rounded-[35px] flex items-center gap-4 shadow-xl">
                        <div class="w-12 h-12 bg-[#3fae2a] text-white rounded-full flex items-center justify-center flex-shrink-0 shadow-lg shadow-green-200">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"></path></svg>
                        </div>
                        <div>
                            <h4 class="text-[#3fae2a] font-black text-sm uppercase tracking-widest">Başvurunuz Alındı!</h4>
                            <p class="text-slate-600 text-xs font-bold"><?php echo e(session('success')); ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="text-center mb-16 space-y-4">
                <div class="inline-flex items-center gap-2 glass-darker px-5 py-2 rounded-full border border-slate-200 shadow-sm">
                    <span class="text-[#3fae2a] font-black text-[10px] uppercase tracking-[0.4em]">Yeni Bir Başlangıç</span>
                </div>
                <h2 class="text-5xl md:text-7xl font-black text-slate-900 tracking-tighter leading-none">
                    Başvuru <span class="text-[#e31e23]">Formu</span>
                </h2>
                <p class="text-slate-500 font-medium text-lg italic tracking-tight">Geleceğinizi Aziz Usta ile bugün inşa etmeye başlayın.</p>
            </div>

            <div class="glass rounded-[60px] p-8 md:p-16 border border-slate-200 shadow-2xl relative bg-white/40">
                <div class="absolute top-0 left-0 w-full h-2 bg-gradient-to-r from-[#e31e23] via-[#3fae2a] to-[#e31e23] rounded-t-[60px]"></div>

                
                <form action="<?php echo e(route('site.application.post')); ?>" method="POST" class="grid md:grid-cols-2 gap-8">
                    <?php echo csrf_field(); ?>

                    <div class="md:col-span-2 flex items-center gap-4 mb-2">
                        <span class="w-8 h-8 rounded-full bg-slate-900 text-white flex items-center justify-center text-xs font-bold">01</span>
                        <h3 class="text-xl font-black text-slate-800 uppercase tracking-tight italic">Kişisel Bilgiler</h3>
                    </div>

                    <div class="flex flex-col gap-2">
                        <label class="text-[11px] font-black text-slate-500 uppercase tracking-widest ml-4">Adınız Soyadınız</label>
                        <input type="text" name="ad_soyad" required value="<?php echo e(old('ad_soyad')); ?>" placeholder="Örn: Ahmet Yılmaz" class="glass-input w-full px-8 py-5 rounded-[28px] border-2 border-slate-200 focus:border-[#e31e23] focus:outline-none focus:ring-4 focus:ring-[#e31e23]/10 transition-all font-bold text-slate-700 placeholder:text-slate-300">
                    </div>

                    <div class="flex flex-col gap-2">
                        <label class="text-[11px] font-black text-slate-500 uppercase tracking-widest ml-4">Telefon Numaranız</label>
                        <input type="tel" name="telefon" required value="<?php echo e(old('telefon')); ?>" placeholder="05xx xxx xx xx" class="glass-input w-full px-8 py-5 rounded-[28px] border-2 border-slate-200 focus:border-[#3fae2a] focus:outline-none focus:ring-4 focus:ring-[#3fae2a]/10 transition-all font-bold text-slate-700 placeholder:text-slate-300">
                    </div>

                    <div class="md:col-span-2">
                        <div class="flex flex-col gap-2">
                            <label class="text-[11px] font-black text-slate-500 uppercase tracking-widest ml-4">E-Posta Adresiniz</label>
                            <input type="email" name="email" required value="<?php echo e(old('email')); ?>" placeholder="ahmet@mail.com" class="glass-input w-full px-8 py-5 rounded-[28px] border-2 border-slate-200 focus:border-[#e31e23] focus:outline-none focus:ring-4 focus:ring-[#e31e23]/10 transition-all font-bold text-slate-700 placeholder:text-slate-300">
                        </div>
                    </div>

                    <div class="md:col-span-2 flex items-center gap-4 mt-8 mb-2">
                        <span class="w-8 h-8 rounded-full bg-slate-900 text-white flex items-center justify-center text-xs font-bold">02</span>
                        <h3 class="text-xl font-black text-slate-800 uppercase tracking-tight italic">Yatırım Planı</h3>
                    </div>

                    <div class="flex flex-col gap-2">
                        <label class="text-[11px] font-black text-slate-500 uppercase tracking-widest ml-4">Şehir / İlçe</label>
                        <input type="text" name="lokasyon" required value="<?php echo e(old('lokasyon')); ?>" placeholder="Örn: Konya / Selçuklu" class="glass-input w-full px-8 py-5 rounded-[28px] border-2 border-slate-200 focus:border-[#e31e23] focus:outline-none focus:ring-4 focus:ring-[#e31e23]/10 transition-all font-bold text-slate-700 placeholder:text-slate-300">
                    </div>

                    <div class="flex flex-col gap-2">
                        <label class="text-[11px] font-black text-slate-500 uppercase tracking-widest ml-4">İşletmecilik Deneyimi</label>
                        <select name="deneyim" required class="glass-input w-full px-8 py-5 rounded-[28px] border-2 border-slate-200 focus:border-[#3fae2a] focus:outline-none transition-all font-bold text-slate-700 appearance-none bg-no-repeat bg-[right_1.5rem_center] bg-[length:1em_1em]" style="background-image: url('data:image/svg+xml;charset=US-ASCII,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%22292.4%22%20height%3D%22292.4%22%3E%3Cpath%20fill%3D%22%23666%22%20d%3D%22M287%2069.4a17.6%2017.6%200%200%200-13-5.4H18.4c-5%200-9.3%201.8-12.9%205.4A17.6%2017.6%200%200%200%200%2082.2c0%205%201.8%209.3%205.4%2012.9l128%20127.9c3.6%203.6%207.8%205.4%2012.8%205.4s9.2-1.8%2012.8-5.4L287%2095c3.5-3.5%205.4-7.8%205.4-12.8%200-5-1.9-9.2-5.5-12.8z%22%2F%3E%3C%2Fsvg%3E');">
                            <option value="" disabled selected>Deneyiminiz var mı?</option>
                            <option value="var" <?php echo e(old('deneyim') == 'var' ? 'selected' : ''); ?>>Evet, deneyimim var</option>
                            <option value="yok" <?php echo e(old('deneyim') == 'yok' ? 'selected' : ''); ?>>Hayır, ilk işim olacak</option>
                        </select>
                    </div>

                    <div class="md:col-span-2 space-y-2">
                        <label class="text-[11px] font-black text-slate-500 uppercase tracking-widest ml-4">Mesajınız</label>
                        <textarea name="mesaj" rows="4" placeholder="Eklemek istediğiniz notlar..." class="glass-input w-full px-8 py-6 rounded-[35px] border-2 border-slate-200 focus:border-[#e31e23] focus:outline-none focus:ring-4 focus:ring-[#e31e23]/10 transition-all font-bold text-slate-700 resize-none placeholder:text-slate-300"><?php echo e(old('mesaj')); ?></textarea>
                    </div>

                    <div class="md:col-span-2 mt-8 flex flex-col items-center gap-6">
                        <button type="submit" class="bg-[#3fae2a] text-white px-20 py-7 rounded-[32px] font-black text-xs uppercase tracking-[0.4em] shadow-[0_20px_40px_-10px_rgba(63,174,42,0.4)] hover:shadow-none hover:bg-slate-900 transition-all w-full md:w-auto active:scale-95">
                            Kendi İşimin Patronu Olmak İstiyorum
                        </button>
                        <p class="text-[11px] text-slate-400 text-center max-w-sm font-medium italic">
                            Bilgileriniz Aziz Usta güvencesiyle korunmaktadır. Başvurunuz uzman ekibimiz tarafından en kısa sürede incelenecektir.
                        </p>
                    </div>

                </form>
            </div>
        </div>
    </section>

    <style>
        .glass-input {
            background: rgba(255, 255, 255, 0.7);
            backdrop-filter: blur(8px);
            -webkit-backdrop-filter: blur(8px);
            box-shadow: inset 0 2px 4px 0 rgba(0, 0, 0, 0.02);
        }
        .glass-input:focus {
            background: #ffffff;
            box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.05);
        }
        select {
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.pages.build', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/berke/PhpstormProjects/azizusta/resources/views/site/pages/application.blade.php ENDPATH**/ ?>