<?php $__env->startSection('title', 'Sertifika ve Belgeler'); ?>
<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/magnific-popup.min.css" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <section class="relative min-h-screen w-full bg-[#fafafa] pt-32 pb-24 px-6 overflow-hidden">

        <div class="absolute top-1/4 left-1/4 w-[500px] h-[500px] bg-[#e31e23]/5 rounded-full blur-[100px] -z-10"></div>
        <div class="absolute bottom-1/4 right-1/4 w-[500px] h-[500px] bg-[#3fae2a]/5 rounded-full blur-[100px] -z-10"></div>

        <div class="max-w-6xl mx-auto relative z-10">

            <div class="text-center mb-16 space-y-4">
                <div class="inline-flex items-center gap-2 glass-darker px-5 py-2 rounded-full border border-white shadow-sm">
                    <span class="text-[#e31e23] font-black text-[10px] uppercase tracking-[0.4em]">Resmi Belgelerimiz</span>
                </div>
                <h2 class="text-5xl md:text-7xl font-black text-slate-900 tracking-tighter italic">Kalite <span class="text-[#3fae2a]">Sertifikalarımız</span></h2>
                <p class="text-slate-500 text-lg max-w-2xl mx-auto leading-relaxed">
                    Uluslararası standartlara uygunluğumuzu belgeleyen resmi sertifikalarımız ve tescil belgelerimiz.
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 popup-gallery">

                <?php $__currentLoopData = $certificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="glass p-4 rounded-[32px] border border-white shadow-lg hover:-translate-y-2 transition-transform duration-500 group">

                        
                        <a href="<?php echo e(asset($cert->image)); ?>"
                           class="block relative rounded-[24px] overflow-hidden aspect-[3/4] cursor-zoom-in">

                            
                            <img src="<?php echo e(asset($cert->image)); ?>"
                                 alt="<?php echo e($cert->title); ?>"
                                 class="w-full h-full object-cover transition-transform duration-700 group-hover:scale-110">

                            
                            <div class="absolute inset-0 bg-slate-900/40 opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex items-center justify-center">
                                <div class="w-16 h-16 bg-white rounded-full flex items-center justify-center shadow-2xl transform scale-0 group-hover:scale-100 transition-transform duration-500 delay-100">
                                    <svg class="w-6 h-6 text-[#e31e23]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                                </div>
                            </div>

                            <div class="absolute top-4 right-4 bg-white/90 backdrop-blur px-3 py-1 rounded-full text-[10px] font-black uppercase tracking-widest text-slate-800 shadow-sm">
                                Resmi Belge
                            </div>
                        </a>

                        <div class="text-center pt-6 pb-2">
                            <h3 class="text-lg font-extrabold text-slate-800"><?php echo e($cert->title); ?></h3>
                            <p class="text-xs text-slate-400 font-bold uppercase tracking-wider mt-1"><?php echo e($cert->subtitle); ?></p>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>

            <div class="mt-20 text-center">
                <div class="glass-darker inline-block px-10 py-6 rounded-[32px] border border-white shadow-sm">
                    <p class="text-slate-500 text-sm font-medium italic">
                        "Belgelerimiz periyodik olarak güncellenmekte ve denetlenmektedir."
                    </p>
                </div>
            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/jquery.magnific-popup.min.js"></script>

    <script>
        $(document).ready(function() {
            $('.popup-gallery').magnificPopup({
                delegate: 'a', // a etiketlerine tıklanınca çalışır
                type: 'image',
                tLoading: 'Resim yükleniyor #%curr%...',
                mainClass: 'mfp-img-mobile',
                gallery: {
                    enabled: true,
                    navigateByImgClick: true,
                    preload: [0,1] // Önceki ve sonraki resmi önbelleğe alır
                },
                image: {
                    tError: '<a href="%url%">Resim #%curr%</a> yüklenemedi.',
                    titleSrc: function(item) {
                        // Alt kısımdaki başlığı (h3) alıp popup'ta gösterir
                        return item.el.parent().find('h3').text();
                    }
                },
                zoom: {
                    enabled: true,
                    duration: 300,
                    opener: function(element) {
                        return element.find('img');
                    }
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('site.pages.build', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/markamix/azizusta.markamix.tr/resources/views/site/pages/certificate.blade.php ENDPATH**/ ?>