<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\ApplicationController;
use Illuminate\Support\Facades\Route;
use App\Models\Application;
use Illuminate\Http\Request;
use App\Http\Controllers\AuthController;
use Illuminate\Support\Facades\File;

Route::get('/', function () {
    $directory = public_path('uploads/gallery');
    $images = [];

    // Klasör mevcutsa içindeki resim dosyalarını çek
    if (File::exists($directory)) {
        // Sadece resim formatlarını (jpg, jpeg, png, webp, gif) alalım
        $files = File::files($directory);

        foreach ($files as $file) {
            // asset() fonksiyonu için uygun yolu oluştur: uploads/gallery/resim.jpg
            $images[] = 'uploads/gallery/' . $file->getFilename();
        }
    }

    $sliders = \App\Models\Slider::where('is_active', 1)->orderBy('rank', 'asc')->get();

    return view('site.pages.index', compact('images', 'sliders'));
})->name('site.index');

Route::post('/iletisim-gonder', [AdminController::class, 'sendMessage'])->name('site.contact.post');

Route::get('/biz-kimiz', function () {
    return view('site.pages.about');
})->name('site.about');

Route::get('/kalite-politikamiz', function () {
    return view('site.pages.quality');
})->name('site.quality');

Route::get('/sertifika-ve-belgeler', function () {
    $certificates = \App\Models\Certificate::where('is_active', 1)->orderBy('rank', 'asc')->get();
    return view('site.pages.certificate', compact('certificates'));
})->name('site.certificate');

Route::get('/bayilerimiz', function () {
    $branches = \App\Models\Branch::where('is_active', true)->get();
    $mapData = $branches->groupBy('city_plate')->map(fn($items) => $items->map(fn($b) => [
        'name' => $b->name, 'type' => $b->type, 'address' => $b->address, 'phone' => $b->phone, 'map_link' => $b->map_link
    ]));
    return view('site.pages.branches', ['branchData' => $mapData]);
})->name('site.branches');

Route::get('/neden-aziz-usta', function () {
    return view('site.pages.why');
})->name('site.why');

Route::get('/franchise-sartlari', function () {
    return view('site.pages.requirements');
})->name('site.requirements');

Route::get('/basvuru-formu', function () {
    return view('site.pages.application');
})->name('site.application');

Route::get('/iletisim', function () {
    return view('site.pages.contact');
})->name('site.contact');

Route::post('/basvuru-formu', function (Request $request) {
    // 1. Veri Doğrulama (Güvenlik için şart)
    $validatedData = $request->validate([
        'ad_soyad' => 'required|string|max:255',
        'telefon'  => 'required|string|max:20',
        'email'    => 'required|email|max:255',
        'lokasyon' => 'required|string|max:255',
        'deneyim'  => 'required|in:var,yok',
        'mesaj'    => 'nullable|string',
        'kvkk_onay'=> 'required' // Formda checkbox'ın işaretlenmiş olması gerekir
    ]);

    // 2. Veritabanına Kayıt
    // $validatedData sadece fillable içindeki alanları içerdiği için güvenlidir
    Application::create($validatedData);

    // 3. Başarılı Mesajı ile Geri Dön
    return back()->with('success', 'Franchise başvurunuz başarıyla alınmıştır. En kısa sürede sizinle iletişime geçeceğiz.');
})->name('site.application.post');

// Giriş Sayfasını Görüntüleme (GET)
Route::get('/admin/login', function () {
    return view('admin.auth.login');
})->name('login');

// Giriş İşlemini Yapma (POST) - URL'yi /admin/login yapıyoruz
Route::post('/admin/login', [AuthController::class, 'login']);

// Çıkış İşlemi
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

Route::prefix('admin')->middleware(['auth'])->group(function () {
    Route::get('/',function (){
        return redirect()->route('admin.applications.index');
    });
    Route::get('/basvurular', [ApplicationController::class, 'index'])->name('admin.applications.index');
    Route::resource('branches', \App\Http\Controllers\BranchController::class);

    Route::get('/ayarlar', [AdminController::class, 'settings'])->name('admin.settings');
    Route::post('/ayarlar', [AdminController::class, 'updateSettings'])->name('admin.settings.update');

    Route::get('/mesajlar', [AdminController::class, 'messages'])->name('admin.messages.index');
    Route::post('/messages/{id}/read', [AdminController::class, 'markAsRead']);
    Route::delete('/messages/{id}', [AdminController::class, 'destroyMessage'])->name('admin.messages.destroy');
    Route::resource('sliders', \App\Http\Controllers\SliderController::class);
    Route::resource('certificates', \App\Http\Controllers\CertificateController::class);
});
