@extends('site.pages.build')
@section('title', 'Neden Aziz Usta?')
@section('content')

    <section class="relative min-h-screen w-full bg-[#fbfcfc] pt-44 pb-32 px-6 overflow-hidden">

        <div class="absolute top-0 left-0 w-full h-full -z-10">
            <div class="absolute top-[10%] left-[5%] w-[40rem] h-[40rem] bg-[#e31e23]/5 rounded-full blur-[120px] animate-pulse"></div>
            <div class="absolute bottom-[10%] right-[5%] w-[40rem] h-[40rem] bg-[#3fae2a]/5 rounded-full blur-[120px] animate-pulse"></div>
        </div>

        <div class="max-w-7xl mx-auto">

            <div class="grid lg:grid-cols-12 gap-8 mb-8">
                <div class="lg:col-span-8 glass rounded-[50px] p-12 md:p-20 border border-white relative overflow-hidden flex flex-col justify-center">
                    <div class="absolute top-0 right-0 p-10 opacity-5 select-none pointer-events-none">
                        <span class="text-[15rem] font-black italic uppercase leading-none">AZİZ</span>
                    </div>
                    <h4 class="text-[#e31e23] font-black tracking-[0.4em] uppercase text-xs mb-6">Yatırımın Geleceği</h4>
                    <h1 class="text-5xl md:text-7xl font-black text-slate-900 leading-tight tracking-tighter mb-8">
                        Neden <span class="text-[#3fae2a]">Aziz Usta?</span>
                    </h1>
                    <p class="text-slate-500 text-xl font-medium leading-relaxed max-w-xl">
                        Türkiye'nin en hızlı büyüyen çiğköfte ailesinde, riskleri minimize eden, kazancı ise maksimize eden <span class="text-slate-900 font-bold underline decoration-[#e31e23] decoration-4 underline-offset-8">kanıtlanmış bir sistem</span> var.
                    </p>
                </div>

                <div class="lg:col-span-4 flex flex-col gap-8">
                    <div class="glass-darker p-10 rounded-[50px] border border-white flex flex-col items-center justify-center flex-1 shadow-xl">
                        <span class="text-6xl font-black text-[#e31e23] mb-2 tracking-tighter">Geniş</span>
                        <span class="text-xs font-black text-slate-400 uppercase tracking-widest leading-none">Bayi Ağı</span>
                    </div>
                    {{-- Bayilerimiz Sayfasına Link --}}
                    <a href="{{ route('site.branches') }}" class="bg-slate-900 p-10 rounded-[50px] flex flex-col items-center justify-center flex-1 shadow-2xl relative overflow-hidden group">
                        <div class="absolute inset-0 bg-gradient-to-tr from-[#3fae2a] to-transparent opacity-0 group-hover:opacity-40 transition-opacity duration-500"></div>
                        <span class="text-6xl font-black text-white mb-2 tracking-tighter italic">~2</span>
                        <span class="text-xs font-black text-slate-400 uppercase tracking-widest leading-none">Günde Kurulum Planı</span>
                    </a>
                </div>
            </div>

            <div class="grid md:grid-cols-3 gap-8">
                <div class="glass p-10 rounded-[50px] border border-white group hover:bg-white transition-all duration-500">
                    <div class="w-14 h-14 bg-red-50 text-[#e31e23] rounded-2xl flex items-center justify-center mb-10 group-hover:scale-110 transition-transform">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 15.546c-.523 0-1.046.151-1.5.454a2.704 2.704 0 01-3 0 2.704 2.704 0 00-3 0 2.704 2.704 0 01-3 0 2.704 2.704 0 00-3 0 2.704 2.704 0 01-3 0 2.701 2.701 0 00-1.5-.454M9 16c0 1.105 1.343 2 3 2s3-.895 3-2M9 10c0 1.105 1.343 2 3 2s3-.895 3-2m-9-3c0 1.105 1.343 2 3 2s3-.895 3-2"></path></svg>
                    </div>
                    <h3 class="text-lg font-black text-slate-800 uppercase tracking-tight mb-4">Aynı Lezzet Garantisi</h3>
                    <p class="text-sm text-slate-500 font-medium leading-relaxed">
                        Merkezi üretim sistemimizle Edirne'den Kars'a her şubede aynı reçete ve aynı kaliteyi sunuyoruz.
                    </p>
                </div>

                <div class="glass p-10 rounded-[50px] border border-white group hover:bg-white transition-all duration-500">
                    <div class="w-14 h-14 bg-green-50 text-[#3fae2a] rounded-2xl flex items-center justify-center mb-10 group-hover:scale-110 transition-transform">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                    </div>
                    <h3 class="text-lg font-black text-slate-800 uppercase tracking-tight mb-4">Sürdürülebilir Kazanç</h3>
                    <p class="text-sm text-slate-500 font-medium leading-relaxed">
                        Düşük fire oranları ve yüksek kâr marjı ile yatırımınızın geri dönüş süresini en aza indiriyoruz.
                    </p>
                </div>

                <div class="glass p-10 rounded-[50px] border border-white group hover:bg-white transition-all duration-500">
                    <div class="w-14 h-14 bg-blue-50 text-blue-500 rounded-2xl flex items-center justify-center mb-10 group-hover:scale-110 transition-transform">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path></svg>
                    </div>
                    <h3 class="text-lg font-black text-slate-800 uppercase tracking-tight mb-4">Operasyonel Destek</h3>
                    <p class="text-sm text-slate-500 font-medium leading-relaxed">
                        Kurulumdan açılışa, personelden reklam süreçlerine kadar uzman ekibimizle her an yanınızdayız.
                    </p>
                </div>
            </div>

            <div class="mt-8 relative group">
                <div class="absolute -inset-1 bg-gradient-to-r from-[#e31e23] to-[#3fae2a] rounded-[60px] blur opacity-20 group-hover:opacity-40 transition duration-1000"></div>
                <div class="relative glass rounded-[60px] p-10 md:p-16 flex flex-col md:flex-row items-center justify-between gap-12 border border-white">
                    <div class="space-y-4 text-center md:text-left">
                        <h3 class="text-4xl font-black text-slate-900 italic">Kendi işinin <span class="text-[#e31e23]">Aziz Usta</span>'sı olmaya hazır mısın?</h3>
                        <p class="text-slate-500 font-bold uppercase tracking-widest text-xs leading-none">Hemen ön başvuru formunu doldur, detayları konuşalım.</p>
                    </div>
                    <div class="flex gap-4">
                        {{-- Franchise Başvuru Sayfasına veya Sayfa İçi Form Çapasına Link --}}
                        <a href="{{ route('site.application') }}#basvuru-formu" class="bg-[#3fae2a] text-white px-10 py-5 rounded-full font-black text-xs uppercase tracking-[0.3em] shadow-xl hover:scale-105 transition-all">
                            Formu Doldur
                        </a>
                    </div>
                </div>
            </div>

        </div>
    </section>



    <style>
        /* Daha belirgin cam efekti */
        .glass {
            background: rgba(255, 255, 255, 0.6);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.4);
        }
        .glass-darker {
            background: rgba(255, 255, 255, 0.85);
            backdrop-filter: blur(20px);
        }

        /* Akıcı scroll için (Eğer form aynı sayfadaysa) */
        html {
            scroll-behavior: smooth;
        }
    </style>

@endsection
