@extends('site.pages.build')
@push('css')
    <style>
        /* Hero Slider Özel Ayarları */
        .myHeroSwiper .swiper-pagination-bullet {
            background: #fff !important;
            opacity: 0.5;
            width: 12px;
            height: 12px;
            transition: all 0.3s;
        }
        .myHeroSwiper .swiper-pagination-bullet-active {
            background: #e31e23 !important;
            opacity: 1;
            width: 30px;
            border-radius: 10px;
        }

        /* Ken Burns Zoom Efekti (Yavaşça Büyüme) */
        @keyframes kenburns {
            0% { transform: scale(1); }
            100% { transform: scale(1.2); }
        }
        .ken-burns-effect {
            animation: kenburns 20s infinite alternate linear;
            transform-origin: center center;
        }

        /* Gradient Yazı Efekti */
        .text-gradient-red {
            background: linear-gradient(to right, #e31e23, #ff4d4d);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
@endpush
@section('content')
    <section class="relative w-full h-screen overflow-hidden">
        <div class="swiper myHeroSwiper w-full h-full">
            <div class="swiper-wrapper">

                @foreach($sliders as $slide)
                    <div class="swiper-slide relative overflow-hidden">
                        {{-- Ken Burns Effect Class'ı ve Resim --}}
                        <img src="{{ asset($slide->image) }}"
                             class="w-full h-full object-cover ken-burns-effect"
                             alt="{{ strip_tags($slide->title) }}">

                        <div class="absolute inset-0 bg-gradient-to-r from-black/60 via-black/20 to-black/60"></div>

                        {{-- Yazı Alanı --}}
                        <div class="absolute inset-0 flex items-center justify-center text-center">
                            <div class="container mx-auto px-6">
                                <div class="max-w-4xl mx-auto space-y-4">
                                    {{--
                                        {!! !!} kullanarak veritabanından gelen HTML etiketlerini çalıştırıyoruz.
                                        Böylece admin panelinden span class="text-red..." yazınca çalışır.
                                    --}}
                                    @if($slide->title)
                                        <h2 class="text-4xl md:text-6xl lg:text-7xl font-black text-white leading-tight drop-shadow-lg">
                                            {!! $slide->title !!}
                                        </h2>
                                    @endif

                                    @if($slide->subtitle)
                                        <p class="text-white/90 text-lg md:text-2xl font-medium drop-shadow-md">
                                            {{ $slide->subtitle }}
                                        </p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach

            </div>
            <div class="swiper-pagination !bottom-10"></div>
        </div>
    </section>
    <section class="pt-44 pb-20 px-6">
        <div class="max-w-6xl mx-auto text-center">
            <div class="inline-block glass-darker px-6 py-2 rounded-full text-[#e31e23] font-bold text-xs uppercase tracking-widest mb-6">
                ✨ Adıyaman'dan Gelen Gerçek Lezzet
            </div>
            <h1 class="text-5xl md:text-7xl font-extrabold text-slate-900 mb-8 leading-tight">
                Her Ayın 15'inde <br> <span class="text-gradient-red italic">+%50 BEDAVA</span>
            </h1>
            <p class="text-slate-500 text-lg max-w-2xl mx-auto leading-relaxed mb-10">
                Lezzet severler iyi bilir, her ayın 15'i Aziz Usta'da bereketli geçer.. <br> Sizleri de bu muhteşem kampanya günümüzde şubelerimize bekliyoruz.
            </p>
            <div class="flex flex-wrap justify-center gap-4">
                {{-- Bayilik Başvuru Sayfasına Yönlendirme --}}
                <a href="{{ route('site.branches') }}" class="bg-[#e31e23] text-white px-10 py-4 rounded-2xl font-bold shadow-2xl shadow-red-200 hover:-translate-y-1 transition flex items-center">
                    Şubelerimiz
                </a>
                {{-- Hakkımızda (Biz Kimiz) Sayfasına Yönlendirme --}}
                <a href="{{ route('site.about') }}" class="glass-darker text-slate-700 px-10 py-4 rounded-2xl font-bold hover:bg-white transition flex items-center">
                    Hakkımızda
                </a>
            </div>
        </div>
    </section>

    <section class="py-12 px-6">
        <div class="max-w-6xl mx-auto grid md:grid-cols-3 gap-6">
            <div class="glass p-8 rounded-[32px] text-center group hover:bg-white transition-all">
                <div class="w-16 h-16 bg-red-50 text-[#e31e23] rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition">
                    <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                </div>
                <h3 class="font-extrabold text-xl mb-3 text-slate-800">Gerçek Ustalık</h3>
                <p class="text-slate-500 text-sm">Yıllara dayanan tecrübe ve aslına uygun tariflerle hazırlanan çiğköfte, her şubede aynı ustalıkla sunulur.</p>
            </div>

            <div class="glass p-8 rounded-[32px] text-center group hover:bg-white transition-all">
                {{-- Linki koruduk, isteğe bağlı değiştirebilirsiniz --}}
                <a href="{{ route('site.branches') }}" class="block h-full">
                    <div class="w-16 h-16 bg-green-50 text-[#3fae2a] rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition">
                        {{-- İkonu "Lezzet" konseptine daha uygun bir ikonla (yaprak/doğallık) güncelledim --}}
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path></svg>
                    </div>
                    <h3 class="font-extrabold text-xl mb-3 text-slate-800">Geleneksel Lezzet</h3>
                    <p class="text-slate-500 text-sm">Çiğköftenin anavatanından gelen reçete, modern üretim anlayışıyla korunur ve yaşatılır.</p>
                </a>
            </div>

            <div class="glass p-8 rounded-[32px] text-center group hover:bg-white transition-all">
                <a href="{{ route('site.why') }}" class="block h-full">
                    <div class="w-16 h-16 bg-blue-50 text-blue-500 rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:scale-110 transition">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path></svg>
                    </div>
                    <h3 class="font-extrabold text-xl mb-3 text-slate-800">Hızlı Kazanç</h3>
                    <p class="text-slate-500 text-sm">Düşük işletme maliyeti ve güçlü marka desteği sayesinde kısa sürede verimli bir yatırım imkânı sağlar.</p>
                </a>
            </div>
        </div>
    </section>

    <section class="relative min-h-screen w-full flex items-center justify-center py-20 overflow-hidden">

        <div class="absolute inset-0 -z-20 bg-gradient-to-br from-[#f8fafc] to-white"></div>
        <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[80%] h-[80%] bg-[#e31e23]/5 rounded-full blur-[150px] animate-pulse"></div>
        <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[60%] h-[60%] bg-[#3fae2a]/5 rounded-full blur-[150px] animate-pulse" style="animation-delay: 2s;"></div>

        <div class="absolute inset-0 flex items-center justify-center opacity-[0.03] -z-10 pointer-events-none scale-125 md:scale-100">
            <svg class="w-full max-w-7xl fill-slate-900" viewBox="0 0 100 100"><path d="M50 0C22.4 0 0 22.4 0 50s22.4 50 50 50 50-22.4 50-50S77.6 0 50 0zm0 90c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zM50 15c-19.3 0-35 15.7-35 35s15.7 35 35 35 35-15.7 35-35-15.7-35-35-35zm0 60c-13.8 0-25-11.2-25-25s11.2-25 25-25 25 11.2 25 25-11.2 25-25 25zM50 30c-11 0-20 9-20 20s9 20 20 20 20-9 20-20-9-20-20-20z"/></svg>
        </div>

        <div class="max-w-4xl mx-auto px-6 relative z-10 text-center">

            <div class="inline-flex items-center gap-3 glass-darker px-6 py-3 rounded-full border border-white shadow-xl mb-12">
                <span class="w-3 h-3 rounded-full bg-[#3fae2a] animate-ping"></span>
                <span class="text-sm font-black text-slate-800 uppercase tracking-[0.3em]">AZİZ USTA KALİTESİ</span>
            </div>

            <h2 class="text-4xl md:text-7xl font-extrabold text-slate-900 leading-[1.1] mb-10">
                "Bizim için çiğköfte <br>
                sadece bir ürün değil, <br>
                bir <span class="text-gradient-red italic">ustalık mirasıdır.</span>"
            </h2>

            <div class="glass-darker p-8 rounded-[40px] border border-white/80 max-w-lg mx-auto shadow-lg">
                <p class="text-slate-600 text-lg md:text-xl leading-relaxed">
                    Her lokmada Adıyaman'ın köklü geleneğini ve Aziz Usta'nın eşsiz tecrübesini hissedin.
                </p>
            </div>

            <div class="mt-16 flex justify-center">
                <a href="{{ route('site.about') }}" class="bg-slate-900 text-white px-10 py-5 rounded-[28px] font-black text-sm uppercase tracking-[0.2em] shadow-lg shadow-slate-200 hover:bg-[#e31e23] transition-colors">
                    Hikayemizi Keşfedin
                </a>
            </div>
        </div>
    </section>

    <section class="relative min-h-screen w-full flex items-center justify-center py-20 px-6 overflow-hidden bg-[#fafaf5]">

        <div class="absolute -bottom-48 -left-48 w-[600px] h-[600px] bg-[#e31e23]/5 rounded-full blur-[120px] -z-10 animate-pulse"></div>
        <div class="absolute -top-48 -right-48 w-[600px] h-[600px] bg-[#3fae2a]/5 rounded-full blur-[120px] -z-10 animate-pulse" style="animation-delay: 3s;"></div>

        <div class="max-w-7xl mx-auto w-full">
            <div class="glass rounded-[60px] p-8 md:p-16 lg:p-20 flex flex-col lg:flex-row items-center gap-12 lg:gap-24 border border-white/80 shadow-[0_32px_64px_-15px_rgba(0,0,0,0.05)]">

                <div class="lg:w-5/12 relative group">
                    <div class="relative z-10 rounded-[48px] overflow-hidden shadow-2xl transition-all duration-700 group-hover:scale-[1.03] group-hover:-rotate-1">

                        <img src="/uploads/durum1.jpeg"
                             alt="Aziz Usta Hakkımızda"
                             class="w-full h-[500px] object-cover transition-transform duration-700 group-hover:scale-110">

                        <div class="absolute inset-0 bg-gradient-to-t from-black/20 to-transparent"></div>
                    </div>

                    <img src="{{ asset($site_settings['logo']) }}" {{-- Lütfen buraya kendi logonuzun yolunu (örn: /images/azizusta-logo.png) yazınız --}}
                    alt="Aziz Usta Logo"
                         class="absolute -bottom-12 -right-8 w-48 h-auto z-20 hidden md:block transform transition-transform duration-500 group-hover:translate-y-[-15px] drop-shadow-2xl">
                    <div class="absolute -top-10 -left-10 w-40 h-40 bg-[#e31e23]/10 rounded-full blur-3xl -z-10 animate-pulse"></div>
                </div>
                <div class="lg:w-7/12 space-y-10">
                    <div class="space-y-4">
                        <div class="inline-flex items-center gap-3 bg-white/60 px-5 py-2 rounded-full border border-white">
                            <span class="w-2 h-2 rounded-full bg-[#3fae2a]"></span>
                            <span class="text-[10px] font-black text-slate-500 uppercase tracking-[0.3em]">Köklerimizden Gelen Güven</span>
                        </div>
                        <h2 class="text-5xl md:text-7xl font-black text-slate-900 leading-[0.9] tracking-tighter">
                            Çiğköftenin Anavatanı <br>
                            <span class="text-[#e31e23] italic">Adıyaman'dan...</span>
                        </h2>
                    </div>

                    <div class="space-y-6 text-slate-600 leading-relaxed text-xl font-medium">
                        <p>
                            Gerçek lezzet, <span class="text-slate-900 font-extrabold underline decoration-[#3fae2a]/30">MEŞHUR ADIYAMAN ÇİĞKÖFTECİSİ AZİZ USTA</span> markasıyla Türkiye’nin dört bir yanına ulaşıyor.
                        </p>
                        <p class="text-base text-slate-500 leading-relaxed">
                            Aslen Adıyamanlı olan Aziz Usta, çocukluk yıllarından bu yana ustalığını gelenekten aldığı bilgi ve tecrübeyle bugün güçlü bir markaya dönüştürmüştür. Merkezi Konya’da bulunan firmamızda <span class="text-[#3fae2a] font-bold italic text-lg">lezzet, kalite ve hijyen</span> her zaman önceliğimizdir.
                        </p>
                    </div>

                    <div class="grid grid-cols-2 gap-y-6 gap-x-4 pt-4 border-t border-slate-200/60">
                        <div class="flex items-center gap-3 group">
                            <div class="w-8 h-8 rounded-full bg-[#e31e23]/10 flex items-center justify-center text-[#e31e23] group-hover:bg-[#e31e23] group-hover:text-white transition-colors italic font-black text-xs">1</div>
                            <span class="text-xs font-black text-slate-700 uppercase tracking-widest leading-none">Lezzetin Son Durağı</span>
                        </div>
                        <div class="flex items-center gap-3 group">
                            <div class="w-8 h-8 rounded-full bg-[#3fae2a]/10 flex items-center justify-center text-[#3fae2a] group-hover:bg-[#3fae2a] group-hover:text-white transition-colors italic font-black text-xs">2</div>
                            <span class="text-xs font-black text-slate-700 uppercase tracking-widest leading-none">Ustalık Her Lokmada</span>
                        </div>
                        <div class="flex items-center gap-3 group">
                            <div class="w-8 h-8 rounded-full bg-[#e31e23]/10 flex items-center justify-center text-[#e31e23] group-hover:bg-[#e31e23] group-hover:text-white transition-colors italic font-black text-xs">3</div>
                            <span class="text-xs font-black text-slate-700 uppercase tracking-widest leading-none">Çiğköftenin Aslı</span>
                        </div>
                        <div class="flex items-center gap-3 group">
                            <div class="w-8 h-8 rounded-full bg-[#3fae2a]/10 flex items-center justify-center text-[#3fae2a] group-hover:bg-[#3fae2a] group-hover:text-white transition-colors italic font-black text-xs">4</div>
                            <span class="text-xs font-black text-slate-700 uppercase tracking-widest leading-none">Ustanın İmzası</span>
                        </div>
                    </div>

                    <div class="pt-8">
                        <div class="glass-darker p-8 rounded-[32px] border border-white shadow-inner flex items-center gap-6">
                            <div class="w-12 h-12 rounded-full bg-[#e31e23] flex flex-shrink-0 items-center justify-center text-white text-2xl italic font-serif">"</div>
                            <p class="italic text-slate-500 text-lg leading-relaxed">
                                Bizim için çiğköfte sadece bir ürün değil, bir <span class="font-bold text-slate-800">ustalık mirasıdır.</span>
                            </p>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <section class="py-32 px-6 relative">

        <div class="absolute -top-24 right-0 w-96 h-96 bg-[#e31e23]/5 rounded-full blur-[100px] -z-10"></div>
        <div class="absolute -bottom-24 left-0 w-96 h-96 bg-[#3fae2a]/5 rounded-full blur-[100px] -z-10"></div>

        <div class="max-w-6xl mx-auto relative">

            <div class="relative z-10 glass rounded-[60px] p-12 md:p-24 overflow-hidden border border-white/80 shadow-sm">

                <div class="absolute inset-0 flex items-center justify-center opacity-[0.03] pointer-events-none select-none -z-10">
                    <span class="text-[15rem] font-black uppercase tracking-tighter">ADIYAMAN</span>
                </div>

                <div class="relative z-20 flex flex-col items-center text-center">

                    <div class="flex items-center gap-4 mb-10">
                        <div class="h-[1px] w-8 bg-[#3fae2a]"></div>
                        <span class="text-[#3fae2a] font-black text-xs uppercase tracking-[0.5em]">Geleneksel Ustalık</span>
                        <div class="h-[1px] w-8 bg-[#3fae2a]"></div>
                    </div>

                    <h2 class="text-4xl md:text-6xl font-black text-slate-900 leading-[1.2] max-w-4xl">
                        Adıyaman’dan çıkan <br>
                        <span class="relative inline-block">
                        <span class="relative z-10 text-[#e31e23]">gerçek çiğköfte</span>
                        <svg class="absolute -bottom-2 left-0 w-full" viewBox="0 0 338 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M3 9C118.5 -1.5 219.5 -1.5 335 9" stroke="#3fae2a" stroke-width="5" stroke-linecap="round"/>
                        </svg>
                    </span>
                        ustalığı, bugün Türkiye’nin dört bir yanında
                        <span class="bg-[#3fae2a]/10 text-[#3fae2a] px-4 py-1 rounded-2xl">aynı lezzetle</span> sunuluyor.
                    </h2>

                    <div class="mt-16 grid grid-cols-2 md:grid-cols-4 gap-8 w-full border-t border-slate-100 pt-16">
                        <div class="flex flex-col gap-1">
                            <span class="text-3xl font-black text-slate-800 tracking-tighter">✓</span>
                            <span class="text-[10px] font-bold text-slate-400 uppercase tracking-widest leading-none">Geleneksel Tat</span>
                        </div>
                        <div class="flex flex-col gap-1">
                            <span class="text-3xl font-black text-[#e31e23] tracking-tighter">81</span>
                            <span class="text-[10px] font-bold text-slate-400 uppercase tracking-widest leading-none">İl Hedefi</span>
                        </div>
                        <div class="flex flex-col gap-1 hidden md:flex">
                            <span class="text-3xl font-black text-[#3fae2a] leading-none">✓</span>
                            <span class="text-[10px] font-bold text-slate-400 uppercase tracking-widest leading-none mt-1">Günlük Üretim</span>
                        </div>
                        <div class="flex flex-col gap-1">
                            <span class="text-3xl font-black text-slate-800 italic">Aziz</span>
                            <span class="text-[10px] font-bold text-[#e31e23] uppercase tracking-widest leading-none">Usta İmzası</span>
                        </div>
                    </div>

                </div>
            </div>

            <div class="absolute -right-6 -bottom-6 w-36 h-36 z-30 animate-bounce duration-[4000ms] hidden lg:block">
                <div class="w-full h-full glass-darker rounded-[32px] shadow-2xl flex flex-col items-center justify-center border border-white text-center p-4">
                    <span class="block text-[#e31e23] font-black text-3xl leading-none">%100</span>
                    <span class="text-[10px] font-bold text-slate-500 uppercase tracking-tight mt-1 leading-tight">Doğal <br> Malzeme</span>
                </div>
            </div>

        </div>
    </section>

    <section class="py-24 px-6 relative overflow-hidden bg-white">
        <div class="max-w-6xl mx-auto">
            <div class="grid lg:grid-cols-12 gap-12 items-center">

                {{-- SOL TARAFA (RESİM ALANI) --}}
                <div class="lg:col-span-5 relative group text-center">

                    {{-- Arkadaki hafif yeşil/kırmızı blur efekti --}}
                    <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[80%] h-[80%] bg-gradient-to-tr from-[#e31e23]/10 to-[#3fae2a]/10 rounded-full blur-[60px] -z-10"></div>

                    {{-- Görsel: Artık kutu içinde değil, serbest duruyor (Drop shadow eklendi) --}}
                    <div class="relative z-10 transition-transform duration-700 group-hover:scale-105">
                        <img src="/uploads/aziz_usta.png"
                             alt="Aziz Usta Ustalık Serüveni"
                             class="w-full max-w-md mx-auto h-auto object-contain drop-shadow-2xl">
                    </div>

                    {{-- Dekoratif Pulse Efektleri --}}
                    <div class="absolute -top-10 -left-10 w-32 h-32 bg-[#e31e23]/5 rounded-full blur-2xl -z-10 animate-pulse"></div>
                    <div class="absolute bottom-10 -right-10 w-32 h-32 bg-[#3fae2a]/5 rounded-full blur-2xl -z-10 animate-pulse" style="animation-delay: 2s;"></div>
                </div>

                {{-- SAĞ TARAF (METİN ALANI) --}}
                <div class="lg:col-span-7 space-y-10">

                    <div class="space-y-4">
                        <div class="inline-flex items-center gap-2 glass-darker px-4 py-2 rounded-full border border-gray-100">
                            <span class="w-2 h-2 rounded-full bg-[#3fae2a]"></span>
                            <span class="text-[10px] font-black text-slate-500 uppercase tracking-[0.2em]">Kısa Tanıtım</span>
                        </div>
                        <h2 class="text-4xl md:text-5xl font-extrabold text-slate-900 leading-tight">
                            Çocukluktan Bugüne <br>
                            <span class="text-gradient-red italic">Aynı Serüven.</span>
                        </h2>
                    </div>

                    {{-- ALINTI KUTUSU: YEŞİL TASARIM --}}
                    <div class="bg-[#3fae2a] p-8 md:p-10 rounded-[32px] shadow-xl shadow-green-200/50 relative overflow-hidden group hover:-translate-y-1 transition-transform duration-300">
                        {{-- Arkaplan dekoratif tırnak işareti --}}
                        <div class="absolute -right-4 -bottom-8 text-[#329621] opacity-50 font-serif text-[10rem] leading-none pointer-events-none">”</div>

                        <p class="text-xl text-white leading-relaxed font-medium italic relative z-10">
                            "Aslen Adıyamanlı olan Aziz Usta’nın çocukluk yıllarında başlayan çiğköfte serüveni, bugün güçlü bir marka olarak yoluna devam ediyor."
                        </p>
                    </div>

                    {{-- İKONLAR: TİK İŞARETLERİ --}}
                    <div class="grid grid-cols-3 gap-4 md:gap-6">

                        {{-- 1. Kutu: LEZZET (Kırmızı Tik) --}}
                        <div class="glass p-6 rounded-[24px] flex flex-col items-center text-center gap-3 border border-white/60 hover:bg-white transition-colors">
                            <div class="w-10 h-10 rounded-full bg-red-50 text-[#e31e23] flex items-center justify-center shadow-sm">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" stroke-width="3" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path></svg>
                            </div>
                            <span class="text-[10px] md:text-xs font-black uppercase tracking-widest text-slate-800">Lezzet</span>
                        </div>

                        {{-- 2. Kutu: KALİTE (Yeşil Tik) --}}
                        <div class="glass p-6 rounded-[24px] flex flex-col items-center text-center gap-3 border border-white/60 hover:bg-white transition-colors">
                            <div class="w-10 h-10 rounded-full bg-green-50 text-[#3fae2a] flex items-center justify-center shadow-sm">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" stroke-width="3" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path></svg>
                            </div>
                            <span class="text-[10px] md:text-xs font-black uppercase tracking-widest text-slate-800">Kalite</span>
                        </div>

                        {{-- 3. Kutu: HİJYEN (Siyah/Gri Tik) --}}
                        <div class="glass p-6 rounded-[24px] flex flex-col items-center text-center gap-3 border border-white/60 hover:bg-white transition-colors">
                            <div class="w-10 h-10 rounded-full bg-slate-100 text-slate-800 flex items-center justify-center shadow-sm">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" stroke-width="3" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path></svg>
                            </div>
                            <span class="text-[10px] md:text-xs font-black uppercase tracking-widest text-slate-800">Hijyen</span>
                        </div>

                    </div>

                    <p class="text-slate-500 text-lg leading-relaxed pl-2 border-l-4 border-slate-200">
                        Standartlarımızdan ödün vermeden üretilen çiğköftelerimiz, <span class="text-slate-900 font-bold">her şubede aynı ustalıkla</span> hazırlanır ve sizlere sunulur.
                    </p>

                </div>
            </div>
        </div>
    </section>

    <section class="py-24 px-6 relative">

        <div class="absolute top-0 right-0 w-[600px] h-[600px] bg-[#3fae2a]/5 rounded-full blur-[120px] -z-10"></div>

        <div class="max-w-6xl mx-auto">
            <div class="grid md:grid-cols-3 gap-8">

                {{-- 1. KART: KIRMIZI --}}
                <div class="bg-[#e31e23] p-10 rounded-[48px] hover:-translate-y-4 transition-all duration-500 group shadow-2xl shadow-red-600/20 relative overflow-hidden">

                    {{-- Hafif dekoratif efekt --}}
                    <div class="absolute top-0 right-0 w-32 h-32 bg-white/5 rounded-full blur-2xl -mr-10 -mt-10 pointer-events-none"></div>

                    {{-- İkon Alanı: Beyaz zemin, Kırmızı ikon --}}
                    <div class="w-20 h-20 bg-white rounded-[28px] flex items-center justify-center mb-8 shadow-lg group-hover:scale-110 transition-transform duration-500">
                        <svg class="w-10 h-10 text-[#e31e23]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M21 15.546c-.523 0-1.046.151-1.5.454a2.704 2.704 0 01-3 0 2.704 2.704 0 00-3 0 2.704 2.704 0 01-3 0 2.704 2.704 0 00-3 0 2.704 2.704 0 01-3 0 2.701 2.701 0 00-1.5-.454M9 16c0 1.105 1.343 2 3 2s3-.895 3-2M9 10c0 1.105 1.343 2 3 2s3-.895 3-2m-9-3c0 1.105 1.343 2 3 2s3-.895 3-2"></path>
                        </svg>
                    </div>

                    <h3 class="text-2xl font-black text-white mb-4 tracking-tight">Gerçek Lezzet</h3>
                    <p class="text-white/90 leading-relaxed font-medium">
                        Adıyaman usulü, nesilden nesile aktarılan <span class="text-white font-extrabold underline decoration-white/50">geleneksel reçete</span> ile gerçek tadı sunuyoruz.
                    </p>

                    <div class="mt-8 flex items-center gap-2 text-white font-black text-xs uppercase tracking-widest opacity-80 group-hover:opacity-100 transition-opacity">
                        <span>Gelenekten Geleceğe</span>
                        <span class="w-8 h-[2px] bg-white/50"></span>
                    </div>
                </div>

                {{-- 2. KART: YEŞİL --}}
                <div class="bg-[#3fae2a] p-10 rounded-[48px] hover:-translate-y-4 transition-all duration-500 group shadow-2xl shadow-green-600/20 relative overflow-hidden">

                    <div class="absolute top-0 right-0 w-32 h-32 bg-white/5 rounded-full blur-2xl -mr-10 -mt-10 pointer-events-none"></div>

                    {{-- İkon Alanı: Beyaz zemin, Yeşil ikon --}}
                    <div class="w-20 h-20 bg-white rounded-[28px] flex items-center justify-center mb-8 shadow-lg group-hover:scale-110 transition-transform duration-500">
                        <svg class="w-10 h-10 text-[#3fae2a]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                        </svg>
                    </div>

                    <h3 class="text-2xl font-black text-white mb-4 tracking-tight">Standart Kalite</h3>
                    <p class="text-white/90 leading-relaxed font-medium">
                        Geniş dağıtım ağımızla, uzman üretim tesisimizden gelen <span class="text-white font-extrabold underline decoration-white/50">her şubede aynı tat</span> ve özeni bulursunuz.
                    </p>

                    <div class="mt-8 flex items-center gap-2 text-white font-black text-xs uppercase tracking-widest opacity-80 group-hover:opacity-100 transition-opacity">
                        <span>Sürdürülebilir Güven</span>
                        <span class="w-8 h-[2px] bg-white/50"></span>
                    </div>
                </div>

                {{-- 3. KART: KOYU (SİYAH/GRİ) --}}
                <div class="bg-slate-900 p-10 rounded-[48px] hover:-translate-y-4 transition-all duration-500 group shadow-2xl shadow-slate-900/20 relative overflow-hidden">

                    <div class="absolute top-0 right-0 w-32 h-32 bg-white/5 rounded-full blur-2xl -mr-10 -mt-10 pointer-events-none"></div>

                    {{-- İkon Alanı: Beyaz zemin, Koyu ikon --}}
                    <div class="w-20 h-20 bg-white rounded-[28px] flex items-center justify-center mb-8 shadow-lg group-hover:scale-110 transition-transform duration-500">
                        <svg class="w-10 h-10 text-slate-900" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12.75L11.25 15 15 9.75m-3-7.036A11.959 11.959 0 013.598 6 11.99 11.99 0 003 9.749c0 5.592 3.824 10.29 9 11.623 5.176-1.333 9-6.03 9-11.622 0-1.31-.21-2.571-.598-3.751A11.956 11.956 0 0112 2.714z"></path>
                        </svg>
                    </div>

                    <h3 class="text-2xl font-black text-white mb-4 tracking-tight">Hijyen Önceliğimiz</h3>
                    <p class="text-white/90 leading-relaxed font-medium">
                        Üretimden servis aşamasına kadar, tüm süreçlerimizde <span class="text-white font-extrabold underline decoration-white/50">tam güven</span> ve yüksek hijyen standartları uygulanır.
                    </p>

                    <div class="mt-8 flex items-center gap-2 text-white font-black text-xs uppercase tracking-widest opacity-80 group-hover:opacity-100 transition-opacity">
                        <span>Sağlıklı ve Güvenli</span>
                        <span class="w-8 h-[2px] bg-white/50"></span>
                    </div>
                </div>

            </div>
        </div>
    </section>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />

<section class="py-24 relative overflow-hidden bg-white/30">
    <div class="absolute top-1/2 right-[-10%] w-[40rem] h-[40rem] bg-[#3fae2a]/5 rounded-full blur-[120px] -z-10"></div>
    <div class="absolute bottom-[-10%] left-[-10%] w-[40rem] h-[40rem] bg-[#e31e23]/5 rounded-full blur-[120px] -z-10"></div>

    <div class="max-w-7xl mx-auto px-6 mb-12">
        <div class="flex flex-col md:flex-row md:items-end justify-between gap-8">
            <div class="space-y-4">
                <div class="inline-flex items-center gap-2 glass px-4 py-2 rounded-full border border-white">
                    <span class="text-[#e31e23] font-black text-[10px] uppercase tracking-[0.3em]">Görsel Bir Şölen</span>
                </div>
                <h2 class="text-5xl md:text-6xl font-black text-slate-900 tracking-tighter leading-tight">
                    Ustanın <span class="text-[#3fae2a]">Mutfağından.</span>
                </h2>
            </div>
        </div>
    </div>

    <div class="swiper myGallerySwiper !pl-[max(1.5rem,calc((100%-80rem)/2))] !pr-6">
        <div class="swiper-wrapper popup-gallery">
            @foreach($images as $imagePath)
                <div class="swiper-slide !w-[300px] md:!w-[400px]">
                    <a href="{{ asset($imagePath) }}" class="relative group/card block rounded-[40px] overflow-hidden glass p-3 border border-white shadow-xl transition-all duration-500 hover:scale-[1.02] hover:-rotate-1">
                        <div class="relative rounded-[32px] overflow-hidden aspect-[4/5]">
                            <img src="{{ asset($imagePath) }}"
                                 alt="Aziz Usta Galeri"
                                 class="w-full h-full object-cover transition-transform duration-1000 group-hover/card:scale-110">

{{--                            <div class="absolute inset-0 bg-gradient-to-t from-slate-900/90 via-transparent to-transparent opacity-0 group-hover/card:opacity-100 transition-all duration-500 flex flex-col justify-end p-8">--}}
{{--                                <span class="text-[#3fae2a] font-black text-[10px] uppercase tracking-[0.4em] mb-2 italic">Aziz Usta</span>--}}
{{--                                <h4 class="text-white text-lg font-black tracking-tighter italic">Büyütmek için tıkla</h4>--}}
{{--                            </div>--}}
                        </div>
                    </a>
                </div>
            @endforeach
        </div>
    </div>

    <div class="mt-16 text-center">
        <a href="{{ route('site.branches') }}" class="group inline-flex items-center gap-4 glass-darker px-8 py-4 rounded-full border border-white shadow-lg transition-all hover:bg-slate-900 hover:text-white">
            <span class="text-[11px] font-black uppercase tracking-[0.2em]">Tüm Şubelerimizi Gör</span>
            <div class="w-7 h-7 rounded-full bg-[#3fae2a] flex items-center justify-center text-white group-hover:rotate-45 transition-transform">
                <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M14 5l7 7m0 0l-7 7m7-7H3"></path></svg>
            </div>
        </a>
    </div>
</section>

<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

<script>
    var swiper = new Swiper(".myGallerySwiper", {
        slidesPerView: "auto", // Kart genişliği CSS'den alınır
        spaceBetween: 30,      // Kartlar arası boşluk
        loop: true,            // Sonsuz döngü
        speed: 800,            // Geçiş hızı
        autoplay: {
            delay: 2500,       // 2.5 saniyede bir kayar
            disableOnInteraction: false, // Kullanıcı dokunsa bile devam eder
            pauseOnMouseEnter: true,    // Mouse üzerine gelince durur
        },
        grabCursor: true,      // El ikonu gösterir
    });
</script>

<style>
    /* Swiper'ın padding ayarlarını taşmaması için */
    .swiper {
        width: 100%;
        height: 100%;
        padding-bottom: 50px !important;
    }
</style>
    <section class="relative min-h-screen w-full flex items-center justify-center overflow-hidden py-20">

        <div class="absolute inset-0 -z-20 bg-[#f8fafc]"></div>
        <div class="absolute top-[-10%] left-[-10%] w-[60%] h-[60%] bg-[#e31e23]/10 rounded-full blur-[120px] animate-pulse"></div>
        <div class="absolute bottom-[-10%] right-[-10%] w-[60%] h-[60%] bg-[#3fae2a]/10 rounded-full blur-[120px] animate-pulse" style="animation-delay: 2s;"></div>

        <div class="absolute inset-0 flex items-center justify-center opacity-[0.04] -z-10 pointer-events-none scale-110 md:scale-100">
            <svg viewBox="0 0 1000 480" xmlns="http://www.w3.org/2000/svg" class="w-full max-w-7xl fill-slate-900">
                <path d="M50,150 L250,120 L450,130 L650,110 L850,130 L950,160 L940,350 L750,380 L550,360 L350,390 L150,370 L40,340 Z" />
            </svg>
        </div>

        <div class="max-w-7xl mx-auto px-6 w-full relative z-10">
            <div class="grid lg:grid-cols-2 gap-12 items-center">

                <div class="space-y-8 text-center lg:text-left">
                    <div class="inline-flex items-center gap-3 glass-darker px-6 py-3 rounded-full border border-white shadow-xl animate-bounce">
                    <span class="relative flex h-3 w-3">
                        <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-[#e31e23] opacity-75"></span>
                        <span class="relative inline-flex rounded-full h-3 w-3 bg-[#e31e23]"></span>
                    </span>
                        <span class="text-sm font-black text-slate-800 uppercase tracking-[0.3em]">Geleneksel Lezzet Ağı</span>
                    </div>

                    <h2 class="text-5xl md:text-8xl font-black text-slate-900 leading-[0.9] tracking-tighter">
                        Tüm Şubelerde, <br>
                        <span class="text-[#e31e23]">Aynı</span> <span class="text-[#3fae2a]">Ustalık.</span>
                    </h2>

                    <p class="text-slate-500 text-xl md:text-2xl font-medium max-w-xl mx-auto lg:mx-0 leading-relaxed">
                        Merkezi <span class="text-slate-900 font-extrabold underline decoration-[#e31e23] decoration-4 underline-offset-4">Konya</span>’da bulunan Aziz Usta, Türkiye geneli yaygın bayi ağıyla dev bir aile olarak büyümeye devam ediyor.
                    </p>

{{--                    <div class="flex flex-wrap justify-center lg:justify-start gap-6 pt-8">--}}
{{--                        <div class="flex flex-col">--}}
{{--                            <span class="text-6xl font-black text-slate-900 tracking-tighter">Yaygın</span>--}}
{{--                            <span class="text-xs font-bold text-[#3fae2a] uppercase tracking-widest">Aktif Lezzet Noktası</span>--}}
{{--                        </div>--}}
{{--                        <div class="w-[1px] h-16 bg-slate-200 hidden md:block"></div>--}}
{{--                        <div class="flex flex-col">--}}
{{--                            <span class="text-6xl font-black text-slate-900 tracking-tighter">7/24</span>--}}
{{--                            <span class="text-xs font-bold text-[#e31e23] uppercase tracking-widest">Kesintisiz Üretim</span>--}}
{{--                        </div>--}}
{{--                    </div>--}}
                </div>

                <div class="relative flex justify-center items-center h-[500px]">

                    <div class="w-full max-w-md glass p-10 rounded-[60px] border border-white/80 shadow-[0_32px_64px_-15px_rgba(0,0,0,0.1)] relative z-20 overflow-hidden transform lg:rotate-3 hover:rotate-0 transition-transform duration-700">
                        <div class="absolute top-0 right-0 w-32 h-32 bg-[#3fae2a]/10 rounded-full blur-3xl"></div>

                        <div class="space-y-8 relative z-10">
                            <div class="flex items-center justify-between">
                                <span class="font-black text-slate-800 italic text-xl">AZİZ USTA</span>
                                <div class="px-3 py-1 bg-[#3fae2a] text-white text-[10px] font-bold rounded-lg uppercase tracking-widest">Canlı Ağ</div>
                            </div>

                            <div class="space-y-4">
                                <div class="flex items-center justify-between p-4 glass-darker rounded-2xl border border-white">
                                    <span class="text-sm font-bold text-slate-700">Genel Merkez</span>
                                    <span class="text-xs font-black text-[#e31e23]">KONYA</span>
                                </div>
                                <div class="flex items-center justify-between p-4 glass-darker rounded-2xl border border-white opacity-80">
                                    <span class="text-sm font-bold text-slate-700">Antalya</span>
                                    <span class="text-xs font-black text-slate-400">AKTİF</span>
                                </div>
                                <div class="flex items-center justify-between p-4 glass-darker rounded-2xl border border-white opacity-60">
                                    <span class="text-sm font-bold text-slate-700">Afyon</span>
                                    <span class="text-xs font-black text-slate-400">AKTİF</span>
                                </div>
                            </div>

                            <button class="w-full bg-slate-900 text-white py-5 rounded-3xl font-black uppercase tracking-[0.2em] text-xs hover:bg-[#e31e23] transition-all shadow-xl shadow-slate-200">
                                Ve Diğer İllerimiz
                            </button>
                        </div>
                    </div>

                    <div class="absolute -top-4 -right-4 w-28 h-28 glass-darker rounded-full flex items-center justify-center z-30 shadow-2xl border border-white animate-bounce" style="animation-duration: 3s;">
                        <div class="text-center leading-none">
                            <span class="block text-2xl font-black text-[#e31e23]">81</span>
                            <span class="text-[8px] font-bold text-slate-500 uppercase">İl Hedefi</span>
                        </div>
                    </div>

                    <div class="absolute -bottom-8 -left-8 w-36 h-36 glass-darker rounded-[40px] flex items-center justify-center z-30 shadow-2xl border border-white animate-pulse">
                        <div class="text-center">
                            <div class="w-10 h-10 bg-[#3fae2a]/20 rounded-xl flex items-center justify-center mx-auto mb-2">
                                <svg class="w-6 h-6 text-[#3fae2a]" fill="currentColor" viewBox="0 0 20 20"><path d="M2 11a1 1 0 011-1h2a1 1 0 011 1v5a1 1 0 01-1 1H3a1 1 0 01-1-1v-5zM8 7a1 1 0 011-1h2a1 1 0 011 1v9a1 1 0 01-1 1H9a1 1 0 01-1-1V7zM14 4a1 1 0 011-1h2a1 1 0 011 1v12a1 1 0 01-1 1h-2a1 1 0 01-1-1V4z"></path></svg>
                            </div>
                            <span class="text-[10px] font-black text-slate-800 uppercase tracking-tighter">Sürekli Büyüme</span>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>

    <section class="py-24 px-6 relative overflow-hidden">

        <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-full h-[500px] bg-gradient-to-r from-[#e31e23]/5 via-white to-[#3fae2a]/5 blur-[120px] -z-10"></div>

        <div class="max-w-6xl mx-auto">
            <div class="glass-darker rounded-[60px] p-8 md:p-20 border border-white/80 shadow-2xl relative overflow-hidden">

                <div class="absolute top-0 right-0 p-12 opacity-[0.03] select-none pointer-events-none">
                    <svg class="w-64 h-64 fill-slate-900" viewBox="0 0 24 24"><path d="M12 2L15.09 8.26L22 9.27L17 14.14L18.18 21.02L12 17.77L5.82 21.02L7 14.14L2 9.27L8.91 8.26L12 2Z"/></svg>
                </div>

                <div class="relative z-10 flex flex-col items-center text-center">

                    <div class="space-y-6 mb-16">
                        <div class="inline-flex items-center gap-2 glass px-4 py-2 rounded-full border border-white">
                            <span class="w-2 h-2 rounded-full bg-[#e31e23] animate-pulse"></span>
                            <span class="text-[10px] font-black text-slate-500 uppercase tracking-[0.3em]">Yatırım Fırsatı</span>
                        </div>
                        <h2 class="text-4xl md:text-6xl font-black text-slate-900 leading-tight tracking-tighter">
                            Kendi İşinizin <br>
                            <span class="text-gradient-red italic">Aziz Usta’sı Olun.</span>
                        </h2>
                    </div>

                    <div class="grid md:grid-cols-3 gap-6 w-full mb-16">
                        <div class="glass p-8 rounded-[40px] border border-white/60 hover:scale-105 transition-transform duration-500">
                            <div class="text-[#e31e23] mb-4 flex justify-center">
                                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path></svg>
                            </div>
                            <h4 class="text-slate-900 font-black text-sm uppercase tracking-widest mb-2">Güçlü Marka</h4>
                            <p class="text-slate-500 text-xs font-bold leading-relaxed">Türkiye çapında bilinirlik ve güven.</p>
                        </div>

                        <div class="glass p-8 rounded-[40px] border border-white/60 hover:scale-105 transition-transform duration-500">
                            <div class="text-[#3fae2a] mb-4 flex justify-center">
                                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path></svg>
                            </div>
                            <h4 class="text-slate-900 font-black text-sm uppercase tracking-widest mb-2">Oturmuş Sistem</h4>
                            <p class="text-slate-500 text-xs font-bold leading-relaxed">Üretimden sevkiyata kusursuz işleyiş.</p>
                        </div>

                        <div class="glass p-8 rounded-[40px] border border-white/60 hover:scale-105 transition-transform duration-500">
                            <div class="text-[#e31e23] mb-4 flex justify-center">
                                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path></svg>
                            </div>
                            <h4 class="text-slate-900 font-black text-sm uppercase tracking-widest mb-2">Sürdürülebilir Kazanç</h4>
                            <p class="text-slate-500 text-xs font-bold leading-relaxed">Yüksek kâr marjı ve sürekli talep.</p>
                        </div>
                    </div>

                    <div class="max-w-2xl mx-auto space-y-10">
                        <p class="text-slate-600 text-lg md:text-xl leading-relaxed">
                            Siz de <span class="font-black text-slate-800">MEŞHUR ADIYAMAN ÇİĞKÖFTECİSİ AZİZ USTA</span> ailesine katılarak bu büyük lezzet yolculuğunda yerinizi alın.
                        </p>

                        <div class="flex flex-col md:flex-row items-center justify-center gap-6">
                            <a href="{{ route('site.application') }}" class="w-full md:w-auto bg-[#e31e23] text-white px-12 py-6 rounded-[28px] font-black text-sm uppercase tracking-[0.2em] shadow-[0_20px_40px_-10px_rgba(227,30,35,0.3)] hover:scale-105 transition-all">
                                Bayilik Başvurusu Yap
                            </a>
                            <a href="{{ route('site.contact') }}" class="w-full md:w-auto glass-darker text-slate-800 px-12 py-6 rounded-[28px] font-black text-sm uppercase tracking-[0.2em] border border-white hover:bg-white transition-all text-center">
                                Bizi Arayın
                            </a>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>

    <section class="py-32 px-6 relative bg-fixed bg-center bg-cover"
             style="background-image: url('/uploads/durum1.jpeg');"> {{-- Arka plan resmini değiştirmeyi unutmayın --}}

        <div class="absolute inset-0 bg-black/70"></div>

        <div class="max-w-4xl mx-auto relative z-10 text-center space-y-8">

            <div class="inline-flex items-center gap-2 bg-white/10 px-5 py-2 rounded-full border border-white/20 backdrop-blur-sm shadow-lg">
                <span class="text-[#3fae2a] font-black text-[10px] uppercase tracking-[0.3em]">Yatırım & Gelecek</span>
            </div>

            <h2 class="text-5xl md:text-7xl font-black text-white tracking-tighter leading-tight drop-shadow-2xl">
                Kendi İşinin <br> <span class="text-[#e31e23]">Patronu Ol.</span>
            </h2>

            <p class="text-slate-300 text-xl max-w-3xl mx-auto leading-relaxed font-medium">
                Güçlü bir marka, kanıtlanmış sistem ve sürdürülebilir kazanç modeliyle <br>
                <span class="text-white font-bold italic underline decoration-[#3fae2a] decoration-4 underline-offset-4">Aziz Usta ailesine katılın.</span>
            </p>

        </div>
    </section>

    <section class="relative min-h-screen w-full bg-[#f8fafc] py-24 px-6 overflow-hidden">

        <div class="absolute top-0 right-0 w-[50%] h-[50%] bg-[#3fae2a]/5 rounded-full blur-[120px] -z-10 animate-pulse"></div>
        <div class="absolute bottom-0 left-0 w-[50%] h-[50%] bg-[#e31e23]/5 rounded-full blur-[120px] -z-10 animate-pulse" style="animation-delay: 3s;"></div>

        <div class="max-w-7xl mx-auto relative z-10">

{{--            <div class="text-center mb-20 space-y-6">--}}
{{--                <div class="inline-flex items-center gap-2 glass-darker px-5 py-2 rounded-full border border-white shadow-sm">--}}
{{--                    <span class="text-[#3fae2a] font-black text-[10px] uppercase tracking-[0.3em]">Yatırım & Gelecek</span>--}}
{{--                </div>--}}
{{--                <h2 class="text-5xl md:text-7xl font-black text-slate-900 tracking-tighter leading-tight">--}}
{{--                    Kendi İşinin <br> <span class="text-[#e31e23]">Patronu Ol.</span>--}}
{{--                </h2>--}}
{{--                <p class="text-slate-500 text-xl max-w-3xl mx-auto leading-relaxed">--}}
{{--                    Güçlü bir marka, kanıtlanmış sistem ve sürdürülebilir kazanç modeliyle <br>--}}
{{--                    <span class="text-slate-900 font-bold italic underline decoration-[#3fae2a] decoration-4">Aziz Usta ailesine katılın.</span>--}}
{{--                </p>--}}
{{--            </div>--}}

            <div class="grid lg:grid-cols-2 gap-8 mb-12">

                <div class="glass p-10 md:p-14 rounded-[50px] border border-white shadow-xl relative overflow-hidden">
                    <div class="absolute top-0 right-0 p-8 opacity-10">
                        <svg class="w-24 h-24" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path></svg>
                    </div>
                    <h3 class="text-3xl font-black text-slate-900 mb-8">Neden Aziz Usta?</h3>
                    <ul class="space-y-6">
                        <li class="flex items-start gap-4 group">
                            <div class="w-6 h-6 rounded-full bg-[#3fae2a] flex-shrink-0 flex items-center justify-center text-white text-[10px]">✔</div>
                            <span class="text-slate-600 font-medium group-hover:text-slate-900 transition-colors">Tanınırlığı yüksek marka gücü ve 100 bayilik başarı.</span>
                        </li>
                        <li class="flex items-start gap-4 group">
                            <div class="w-6 h-6 rounded-full bg-[#3fae2a] flex-shrink-0 flex items-center justify-center text-white text-[10px]">✔</div>
                            <span class="text-slate-600 font-medium group-hover:text-slate-900 transition-colors">Standart üretim ve her şubede aynı lezzet garantisi.</span>
                        </li>
                        <li class="flex items-start gap-4 group">
                            <div class="w-6 h-6 rounded-full bg-[#3fae2a] flex-shrink-0 flex items-center justify-center text-white text-[10px]">✔</div>
                            <span class="text-slate-600 font-medium group-hover:text-slate-900 transition-colors">Eğitim, kurulum ve profesyonel operasyon desteği.</span>
                        </li>
                        <li class="flex items-start gap-4 group">
                            <div class="w-6 h-6 rounded-full bg-[#3fae2a] flex-shrink-0 flex items-center justify-center text-white text-[10px]">✔</div>
                            <span class="text-slate-600 font-medium group-hover:text-slate-900 transition-colors">Düşük operasyon maliyeti ve hızlı geri dönüşlü yatırım.</span>
                        </li>
                    </ul>
                    <div class="mt-12 p-6 glass-darker rounded-3xl border border-white">
                        <p class="text-sm font-black text-[#e31e23] italic">"Bugün bir şube, yarın güçlü bir işletme. Gücünü markadan al!"</p>
                    </div>
                </div>

                <div class="glass p-10 md:p-14 rounded-[50px] border border-white shadow-xl bg-white/40 flex flex-col justify-between">
                    <div>
                        <h3 class="text-3xl font-black text-slate-900 mb-8">Franchise Şartları</h3>
                        <div class="space-y-8">
                            <div class="border-b border-slate-200 pb-4">
                                <h4 class="font-black text-[#e31e23] text-xs uppercase tracking-widest mb-2">Genel Beklentimiz</h4>
                                <p class="text-slate-500 text-sm font-bold">Girişimci ruh, iş bizzat sahiplenme ve marka standartlarına tam uyum.</p>
                            </div>
                            <div class="border-b border-slate-200 pb-4">
                                <h4 class="font-black text-[#3fae2a] text-xs uppercase tracking-widest mb-2">Lokasyon & Mağaza</h4>
                                <p class="text-slate-500 text-sm font-bold">Yüksek yaya trafiği olan cadde veya merkezi AVM noktaları.</p>
                            </div>
                            <div class="border-b border-slate-200 pb-4">
                                <h4 class="font-black text-slate-800 text-xs uppercase tracking-widest mb-2">İşletme Modeli</h4>
                                <p class="text-slate-500 text-sm font-bold">Merkezden ürün temini, standart reçete ve tam hijyen disiplini.</p>
                            </div>
                            <div class="pb-4">
                                <h4 class="font-black text-blue-500 text-xs uppercase tracking-widest mb-2">Eğitim & Destek</h4>
                                <p class="text-slate-500 text-sm font-bold">Açılış öncesi operasyonel eğitim ve sürekli denetim desteği.</p>
                            </div>
                        </div>
                    </div>

                    <div class="mt-8 pt-6 border-t border-slate-200/60">
                        <a href="{{ route('site.application') }}" class="group w-full flex items-center justify-center gap-3 bg-[#e31e23] text-white py-5 rounded-[28px] font-black text-xs uppercase tracking-[0.2em] shadow-xl shadow-red-200 transition-all hover:bg-slate-900 hover:scale-[1.02] hover:shadow-2xl">
                            <span>Hemen Başvur</span>
                            <svg class="w-4 h-4 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"></path></svg>
                        </a>
                    </div>

                </div>
            </div>

{{--            <div id="basvuru" class="max-w-5xl mx-auto mt-20">--}}
{{--                <div class="glass rounded-[60px] p-8 md:p-16 shadow-2xl relative border-t-4 border-[#3fae2a]">--}}
{{--                    <div class="text-center mb-12">--}}
{{--                        <h3 class="text-4xl font-black text-slate-900 mb-4">Ön Başvuru Formu</h3>--}}
{{--                        <p class="text-slate-400 font-bold uppercase text-[10px] tracking-[0.4em]">Hayalini erteleme, hemen aramıza katıl</p>--}}
{{--                    </div>--}}
{{--                    @if(session('success'))--}}
{{--                        <div class="max-w-5xl mx-auto mb-6">--}}
{{--                            <div class="glass p-6 rounded-[30px] border-2 border-[#3fae2a]/30 bg-green-50/50 flex items-center gap-4 animate-bounce">--}}
{{--                                <div class="w-10 h-10 bg-[#3fae2a] text-white rounded-full flex items-center justify-center flex-shrink-0 font-bold">✓</div>--}}
{{--                                <p class="text-[#3fae2a] font-black text-sm uppercase tracking-wider">--}}
{{--                                    {{ session('success') }}--}}
{{--                                </p>--}}
{{--                            </div>--}}
{{--                        </div>--}}
{{--                    @endif--}}

{{--                    --}}{{-- Route ismini projenize göre (örn: site.application.post) güncelleyebilirsiniz --}}
{{--                    <form action="{{ route('site.application.post') }}" method="POST" class="grid md:grid-cols-2 gap-6">--}}
{{--                        @csrf --}}{{-- Laravel Güvenlik Tokenı --}}

{{--                        <div class="space-y-2">--}}
{{--                            <label class="text-[10px] font-black uppercase text-slate-400 ml-4">Ad Soyad (Zorunlu)</label>--}}
{{--                            <input type="text" name="ad_soyad" required value="{{ old('ad_soyad') }}" class="w-full glass-darker p-5 rounded-3xl outline-none focus:ring-2 focus:ring-[#3fae2a] transition border border-white shadow-inner">--}}
{{--                        </div>--}}

{{--                        <div class="space-y-2">--}}
{{--                            <label class="text-[10px] font-black uppercase text-slate-400 ml-4">Telefon Numarası (Zorunlu)</label>--}}
{{--                            <input type="tel" name="telefon" required value="{{ old('telefon') }}" class="w-full glass-darker p-5 rounded-3xl outline-none focus:ring-2 focus:ring-[#3fae2a] transition border border-white shadow-inner">--}}
{{--                        </div>--}}

{{--                        <div class="space-y-2">--}}
{{--                            <label class="text-[10px] font-black uppercase text-slate-400 ml-4">E-Posta Adresi (Zorunlu)</label>--}}
{{--                            <input type="email" name="email" required value="{{ old('email') }}" class="w-full glass-darker p-5 rounded-3xl outline-none focus:ring-2 focus:ring-[#3fae2a] transition border border-white shadow-inner">--}}
{{--                        </div>--}}

{{--                        <div class="space-y-2">--}}
{{--                            <label class="text-[10px] font-black uppercase text-slate-400 ml-4">Açmak İstediğiniz İl / İlçe</label>--}}
{{--                            <input type="text" name="lokasyon" required value="{{ old('lokasyon') }}" class="w-full glass-darker p-5 rounded-3xl outline-none focus:ring-2 focus:ring-[#3fae2a] transition border border-white shadow-inner">--}}
{{--                        </div>--}}

{{--                        <div class="md:col-span-2 space-y-4">--}}
{{--                            <label class="text-[10px] font-black uppercase text-slate-400 ml-4 block">Daha Önce İşletmecilik Deneyiminiz Var mı?</label>--}}
{{--                            <div class="flex gap-6">--}}
{{--                                <label class="flex items-center gap-3 cursor-pointer">--}}
{{--                                    <input type="radio" name="deneyim" value="var" {{ old('deneyim') == 'var' ? 'checked' : '' }} class="w-5 h-5 accent-[#3fae2a]">--}}
{{--                                    <span class="font-bold text-slate-700">Var</span>--}}
{{--                                </label>--}}
{{--                                <label class="flex items-center gap-3 cursor-pointer">--}}
{{--                                    <input type="radio" name="deneyim" value="yok" {{ old('deneyim') == 'yok' ? 'checked' : '' }} class="w-5 h-5 accent-[#3fae2a]">--}}
{{--                                    <span class="font-bold text-slate-700">Yok</span>--}}
{{--                                </label>--}}
{{--                            </div>--}}
{{--                        </div>--}}

{{--                        <div class="md:col-span-2 space-y-2">--}}
{{--                            <label class="text-[10px] font-black uppercase text-slate-400 ml-4">Mesajınız (Opsiyonel)</label>--}}
{{--                            <textarea name="mesaj" rows="4" class="w-full glass-darker p-5 rounded-3xl outline-none focus:ring-2 focus:ring-[#3fae2a] transition border border-white shadow-inner">{{ old('mesaj') }}</textarea>--}}
{{--                        </div>--}}

{{--                        <div class="md:col-span-2 py-4 flex items-start gap-4">--}}
{{--                            <input type="checkbox" name="kvkk_onay" id="kvkk" required class="mt-1 w-5 h-5 accent-[#3fae2a]">--}}
{{--                            <label for="kvkk" class="text-[11px] text-slate-500 font-medium leading-relaxed italic cursor-pointer">--}}
{{--                                Kişisel verilerimin, franchise başvurum kapsamında benimle iletişime geçilmesi amacıyla kullanılmasını ve KVKK metnini kabul ediyorum.--}}
{{--                            </label>--}}
{{--                        </div>--}}

{{--                        <div class="md:col-span-2 pt-6">--}}
{{--                            <button type="submit" class="w-full bg-[#3fae2a] hover:bg-slate-900 text-white font-black py-6 rounded-3xl text-sm uppercase tracking-[0.3em] shadow-2xl shadow-green-200 transition-all active:scale-95">--}}
{{--                                Kendi İşimin Patronu Olmak İstiyorum--}}
{{--                            </button>--}}
{{--                        </div>--}}
{{--                    </form>--}}
{{--                </div>--}}
{{--            </div>--}}
        </div>
    </section>

@endsection
@push('js')
    <script>
        $(document).ready(function() {
            $('.popup-gallery').magnificPopup({
                delegate: 'a', // 'a' etiketlerine tıklandığında tetiklenir
                type: 'image',
                tLoading: 'Resim yükleniyor #%curr%...',
                mainClass: 'mfp-img-mobile',
                gallery: {
                    enabled: true, // Galeri modunu açar (Önceki/Sonraki butonları)
                    navigateByImgClick: true,
                    preload: [0,1] // Önceki ve sonraki resimleri önceden yükler
                },
                image: {
                    tError: '<a href="%url%">Resim #%curr%</a> yüklenemedi.',
                    titleSrc: function(item) {
                        return 'Aziz Usta Lezzet Galerisi';
                    }
                },
                zoom: {
                    enabled: true,
                    duration: 300, // Açılış animasyon hızı
                    opener: function(element) {
                        return element.find('img');
                    }
                }
            });
        });
    </script>
    <script>
        var heroSwiper = new Swiper(".myHeroSwiper", {
            loop: true,
            speed: 1500, // Geçiş süresi biraz artırıldı (daha yumuşak)
            effect: "fade",
            fadeEffect: {
                crossFade: true
            },
            autoplay: {
                delay: 6000, // Bekleme süresi artırıldı
                disableOnInteraction: false,
            },
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
            // Navigation (Oklar) JS ayarlarından da kaldırıldı
        });

        // Sayfa içindeki diğer swiper'ınız (Gallery) burada kalmaya devam etsin...
    </script>
@endpush
