<nav class="fixed inset-x-0 top-4 z-50 px-4 sm:px-6">
    <div class="mx-auto max-w-6xl">
        <div class="flex items-center justify-between rounded-2xl border border-white/40 bg-white/60 backdrop-blur-xl shadow-[0_18px_40px_-25px_rgba(0,0,0,0.35)] px-4 sm:px-6 py-3">

            {{-- Logo --}}
            <a href="{{ route('site.index') }}" class="flex items-center gap-2 flex-shrink-0">
                @if(isset($site_settings['logo']))
                    <img
                            src="{{ asset($site_settings['logo']) }}"
                            alt="Aziz Usta Logo"
                            class="h-12 sm:h-16 w-auto object-contain transition-transform hover:scale-[1.03]"
                    >
                @else
                    <span class="font-black text-2xl sm:text-3xl tracking-tighter text-[#e31e23]">
                        AZİZ <span class="text-[#3fae2a]">USTA</span>
                    </span>
                @endif
            </a>

            {{-- Desktop Menü --}}
            <div class="hidden lg:flex items-center gap-1">
                <a href="{{ route('site.index') }}"
                   class="px-4 py-2 rounded-xl text-[13px] font-extrabold uppercase tracking-wide text-slate-700 hover:bg-white/70 hover:text-[#e31e23] transition">
                    Ana Sayfa
                </a>

                {{-- Kurumsal (Dropdown) --}}
                <div class="relative">
                    <button
                            type="button"
                            class="js-dd-btn flex items-center gap-2 px-4 py-2 rounded-xl text-[13px] font-extrabold uppercase tracking-wide text-slate-700 hover:bg-white/70 hover:text-[#e31e23] transition"
                            aria-haspopup="true"
                            aria-expanded="false"
                            data-dd="kurumsal"
                    >
                        Kurumsal
                        <svg class="h-4 w-4 transition-transform js-dd-chevron" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 9l6 6 6-6"></path>
                        </svg>
                    </button>

                    <div
                            class="js-dd-panel absolute left-0 mt-2 w-[340px] rounded-2xl border border-white/40 bg-white/85 backdrop-blur-xl shadow-[0_22px_50px_-30px_rgba(0,0,0,0.45)] p-2 hidden"
                            data-dd-panel="kurumsal"
                            role="menu"
                    >
                        <a href="{{ route('site.about') }}" class="group block rounded-xl px-4 py-3 hover:bg-[#e31e23]/10 transition" role="menuitem">
                            <div class="flex items-center justify-between">
                                <span class="font-bold text-slate-800 group-hover:text-[#e31e23]">Biz Kimiz?</span>
                                <span class="text-[11px] font-black text-slate-400 group-hover:text-[#e31e23]">→</span>
                            </div>
                            <span class="block text-[11px] text-slate-500">Hakkımızda, Misyon, Vizyon</span>
                        </a>
                        <a href="{{ route('site.quality') }}" class="block rounded-xl px-4 py-3 font-bold text-slate-800 hover:bg-[#e31e23]/10 hover:text-[#e31e23] transition" role="menuitem">
                            Kalite Politikamız
                        </a>
                        <a href="{{ route('site.certificate') }}" class="block rounded-xl px-4 py-3 font-bold text-slate-800 hover:bg-[#e31e23]/10 hover:text-[#e31e23] transition" role="menuitem">
                            Sertifika ve Belgeler
                        </a>
                    </div>
                </div>

                <a href="{{ route('site.branches') }}"
                   class="px-4 py-2 rounded-xl text-[13px] font-extrabold uppercase tracking-wide text-slate-700 hover:bg-white/70 hover:text-[#e31e23] transition">
                    Bayilerimiz
                </a>

                {{-- Franchise (Dropdown) --}}
                <div class="relative">
                    <button
                            type="button"
                            class="js-dd-btn flex items-center gap-2 px-4 py-2 rounded-xl text-[13px] font-extrabold uppercase tracking-wide text-slate-700 hover:bg-white/70 hover:text-[#3fae2a] transition"
                            aria-haspopup="true"
                            aria-expanded="false"
                            data-dd="franchise"
                    >
                        Franchise
                        <svg class="h-4 w-4 transition-transform js-dd-chevron" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 9l6 6 6-6"></path>
                        </svg>
                    </button>

                    <div
                            class="js-dd-panel absolute left-0 mt-2 w-[340px] rounded-2xl border border-white/40 bg-white/85 backdrop-blur-xl shadow-[0_22px_50px_-30px_rgba(0,0,0,0.45)] p-2 hidden"
                            data-dd-panel="franchise"
                            role="menu"
                    >
                        <a href="{{ route('site.why') }}" class="block rounded-xl px-4 py-3 font-bold text-slate-800 hover:bg-[#3fae2a]/10 hover:text-[#3fae2a] transition" role="menuitem">
                            Neden Aziz Usta?
                        </a>
                        <a href="{{ route('site.requirements') }}" class="block rounded-xl px-4 py-3 font-bold text-slate-800 hover:bg-[#3fae2a]/10 hover:text-[#3fae2a] transition" role="menuitem">
                            Franchise Şartlarımız
                        </a>
                        <a href="{{ route('site.application') }}" class="block rounded-xl px-4 py-3 font-bold text-slate-800 hover:bg-[#3fae2a]/10 hover:text-[#3fae2a] transition" role="menuitem">
                            Franchise Başvuru Formu
                        </a>
                    </div>
                </div>

                {{-- İletişim --}}
                <a href="{{ route('site.contact') }}"
                   class="px-4 py-2 rounded-xl text-[13px] font-extrabold uppercase tracking-wide text-slate-700 hover:bg-white/70 hover:text-[#e31e23] transition">
                    İletişim
                </a>
            </div>

            {{-- Sağ Aksiyonlar --}}
            <div class="flex items-center gap-3">

                {{--
                    DÜZELTME: Bu buton mobilde GİZLENDİ (hidden sm:inline-flex).
                    Böylece logo ve hamburger menü sıkışmayacak.
                --}}
                <a href="tel:{{ $site_settings['phone'] ?? '02120000000' }}"
                   class="hidden sm:inline-flex items-center justify-center bg-[#3fae2a] text-white px-5 sm:px-7 py-3 rounded-xl text-[11px] sm:text-xs font-black tracking-widest uppercase shadow-[0_12px_22px_-10px_rgba(63,174,42,0.55)] hover:scale-[1.03] transition">
                    Bizi Arayın
                </a>

                {{-- Mobil Hamburger --}}
                <button
                        type="button"
                        class="lg:hidden inline-flex h-11 w-11 items-center justify-center rounded-xl border border-white/40 bg-white/60 backdrop-blur-xl hover:bg-white/80 transition"
                        aria-label="Menüyü Aç/Kapat"
                        id="mobileMenuBtn"
                        aria-expanded="false"
                >
                    <svg class="h-6 w-6 text-slate-800" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
            </div>
        </div>

        {{-- Mobil Menü Panel --}}
        <div id="mobileMenu"
             class="lg:hidden mt-3 hidden rounded-2xl border border-white/40 bg-white/95 backdrop-blur-xl shadow-[0_18px_40px_-25px_rgba(0,0,0,0.35)] overflow-hidden">
            <div class="p-2 h-[80vh] overflow-y-auto"> {{-- Menü çok uzunsa scroll olsun --}}
                <a href="{{ route('site.index') }}" class="block px-4 py-3 rounded-xl font-extrabold text-slate-800 hover:bg-white/70 transition">Ana Sayfa</a>
                <a href="{{ route('site.branches') }}" class="block px-4 py-3 rounded-xl font-extrabold text-slate-800 hover:bg-white/70 transition">Bayilerimiz</a>
                <a href="{{ route('site.contact') }}" class="block px-4 py-3 rounded-xl font-extrabold text-slate-800 hover:bg-white/70 transition">İletişim</a>

                <div class="my-2 h-px bg-black/5"></div>

                <div class="px-2 py-2 text-[10px] font-black tracking-widest uppercase text-slate-400">Kurumsal</div>
                <a href="{{ route('site.about') }}" class="block px-4 py-3 rounded-xl font-bold text-slate-800 hover:bg-[#e31e23]/10 hover:text-[#e31e23] transition">Biz Kimiz?</a>
                <a href="{{ route('site.quality') }}" class="block px-4 py-3 rounded-xl font-bold text-slate-800 hover:bg-[#e31e23]/10 hover:text-[#e31e23] transition">Kalite Politikamız</a>
                <a href="{{ route('site.certificate') }}" class="block px-4 py-3 rounded-xl font-bold text-slate-800 hover:bg-[#e31e23]/10 hover:text-[#e31e23] transition">Sertifika ve Belgeler</a>

                <div class="my-2 h-px bg-black/5"></div>

                <div class="px-2 py-2 text-[10px] font-black tracking-widest uppercase text-slate-400">Franchise</div>
                <a href="{{ route('site.why') }}" class="block px-4 py-3 rounded-xl font-bold text-slate-800 hover:bg-[#3fae2a]/10 hover:text-[#3fae2a] transition">Neden Aziz Usta?</a>
                <a href="{{ route('site.requirements') }}" class="block px-4 py-3 rounded-xl font-bold text-slate-800 hover:bg-[#3fae2a]/10 hover:text-[#3fae2a] transition">Franchise Şartlarımız</a>
                <a href="{{ route('site.application') }}" class="block px-4 py-3 rounded-xl font-bold text-slate-800 hover:bg-[#3fae2a]/10 hover:text-[#3fae2a] transition">Franchise Başvuru Formu</a>

                <div class="my-4 h-px bg-black/5"></div>

                {{-- MOBİL İÇİN BİZİ ARAYIN BUTONU --}}
                <a href="tel:{{ $site_settings['phone'] ?? '02120000000' }}"
                   class="flex items-center justify-center gap-2 w-full bg-[#3fae2a] text-white px-5 py-4 rounded-xl text-xs font-black tracking-widest uppercase shadow-lg mb-2">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
                    Bizi Arayın
                </a>
            </div>
        </div>
    </div>
</nav>

<script>
    (function () {
        const btns = Array.from(document.querySelectorAll('.js-dd-btn'));
        const panels = Array.from(document.querySelectorAll('.js-dd-panel'));

        function closeAll() {
            panels.forEach(p => p.classList.add('hidden'));
            btns.forEach(b => {
                b.setAttribute('aria-expanded', 'false');
                const chev = b.querySelector('.js-dd-chevron');
                if (chev) chev.classList.remove('rotate-180');
            });
        }

        btns.forEach(btn => {
            btn.addEventListener('click', (e) => {
                e.stopPropagation();
                const key = btn.dataset.dd;
                const panel = document.querySelector(`[data-dd-panel="${key}"]`);
                const isOpen = panel && !panel.classList.contains('hidden');

                closeAll();

                if (panel && !isOpen) {
                    panel.classList.remove('hidden');
                    btn.setAttribute('aria-expanded', 'true');
                    const chev = btn.querySelector('.js-dd-chevron');
                    if (chev) chev.classList.add('rotate-180');
                }
            });
        });

        document.addEventListener('click', () => closeAll());
        document.addEventListener('keydown', (e) => {
            if (e.key === 'Escape') closeAll();
        });

        // Mobile menu toggle
        const mobileBtn = document.getElementById('mobileMenuBtn');
        const mobileMenu = document.getElementById('mobileMenu');

        if (mobileBtn && mobileMenu) {
            mobileBtn.addEventListener('click', (e) => {
                e.stopPropagation();
                const willOpen = mobileMenu.classList.contains('hidden');
                mobileMenu.classList.toggle('hidden');
                mobileBtn.setAttribute('aria-expanded', willOpen ? 'true' : 'false');
                closeAll();
            });

            document.addEventListener('click', () => {
                mobileMenu.classList.add('hidden');
                mobileBtn.setAttribute('aria-expanded', 'false');
            });

            mobileMenu.addEventListener('click', (e) => e.stopPropagation());
        }
    })();
</script>