<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>@yield('title', 'Aziz Usta') | {{ $site_settings['site_title'] ?? 'Meşhur Adıyaman Çiğköftecisi' }}</title>
    <meta name="description" content="{{ $site_settings['meta_description'] ?? 'Aziz Usta ustalığıyla hazırlanan meşhur Adıyaman çiğköftesi.' }}">
    <meta name="keywords" content="{{ $site_settings['meta_keywords'] ?? 'çiğköfte, aziz usta, bayilik, franchise' }}">

    @if(isset($site_settings['favicon']))
        <link rel="icon" type="image/png" href="{{ asset($site_settings['favicon']) }}">
    @else
        <link rel="icon" type="image/png" href="{{ asset('default-favicon.png') }}">
    @endif

    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.13.3/dist/cdn.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/magnific-popup.min.css">

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/jquery.magnific-popup.min.js"></script>
    <style>
        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
            background-color: #f8fafc;
            overflow-x: hidden;
            color: #1e293b;
        }

        /* Akışkan Arka Plan Efektleri (Marka Renklerine Göre Dinamik) */
        .blobs-container {
            position: fixed; /* Sayfa kaydırılsa bile arka planda sabit kalır */
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            overflow: hidden; /* Dışarı taşan kısımları keser, scroll oluşturmaz */
            z-index: -1; /* En arkada kalmasını sağlar */
            pointer-events: none; /* Tıklamaları engellemez, içinden geçip linklere tıklanabilir */
        }

        /* Akışkan Arka Plan Efektleri */
        .liquid-blob {
            position: absolute;
            width: 500px;
            height: 500px;
            border-radius: 50%;
            filter: blur(80px);
            opacity: 0.4;
            animation: move 20s infinite alternate;
        }
        /* Aziz Usta Kırmızı */
        .blob-1 { background: #e31e23; top: -150px; left: -150px; }
        /* Aziz Usta Yeşil */
        .blob-2 { background: #3fae2a; bottom: -150px; right: -150px; animation-delay: -5s; }
        @keyframes move {
            from { transform: translate(0, 0) scale(1); }
            to { transform: translate(50px, 50px) scale(1.1); } /* Hareketi biraz yumuşattım */
        }

        /* Modern Glassmorphism Efektleri */
        .glass {
            background: rgba(255, 255, 255, 0.4);
            backdrop-filter: blur(15px);
            -webkit-backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 255, 255, 0.7);
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.05);
        }

        .glass-darker {
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 1);
        }

        /* Marka Gradyanı */
        .text-gradient-red {
            background: linear-gradient(to right, #e31e23, #ff4d4d);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        /* Custom Scrollbar */
        ::-webkit-scrollbar { width: 8px; }
        ::-webkit-scrollbar-track { background: #f1f1f1; }
        ::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 10px; }
        ::-webkit-scrollbar-thumb:hover { background: #e31e23; }

        @media (max-width: 768px) {
            .liquid-blob {
                width: 250px;  /* Mobilde boyutu küçültüyoruz */
                height: 250px;
                filter: blur(60px); /* Bulanıklığı azaltıyoruz */
            }

            /* Mobilde konumları biraz daha içeri çekebiliriz */
            .blob-1 { top: -50px; left: -50px; }
            .blob-2 { bottom: -50px; right: -50px; }
        }
    </style>
    @stack('css')
</head>
