@extends('admin.pages.build')

@section('content')
    <div class="max-w-6xl">
        <div class="mb-10 flex justify-between items-end">
            <div>
                <h1 class="text-4xl font-black text-slate-900 tracking-tighter">Gelen <span class="text-[#3fae2a]">Mesajlar</span></h1>
                <p class="text-slate-400 font-bold text-[10px] uppercase tracking-[0.3em] mt-2">İletişim Formu Üzerinden Gelen Başvurular</p>
            </div>
            <div class="flex gap-4">
                <div class="glass px-6 py-3 rounded-2xl border border-white shadow-sm flex items-center gap-3">
                    <span class="w-3 h-3 rounded-full bg-[#e31e23] animate-pulse"></span>
                    <span class="text-xs font-black text-slate-700 uppercase tracking-widest">{{ $messages->where('is_read', 0)->count() }} Yeni Mesaj</span>
                </div>
            </div>
        </div>

        <div class="glass rounded-[40px] border border-white shadow-2xl overflow-hidden bg-white/40">
            <table class="w-full text-left border-collapse">
                <thead>
                <tr class="bg-slate-900/5 border-b border-slate-100">
                    <th class="p-6 text-[10px] font-black uppercase text-slate-400 tracking-widest">Durum</th>
                    <th class="p-6 text-[10px] font-black uppercase text-slate-400 tracking-widest">Gönderen</th>
                    <th class="p-6 text-[10px] font-black uppercase text-slate-400 tracking-widest">Konu</th>
                    <th class="p-6 text-[10px] font-black uppercase text-slate-400 tracking-widest">Tarih</th>
                    <th class="p-6 text-[10px] font-black uppercase text-slate-400 tracking-widest text-right">İşlem</th>
                </tr>
                </thead>
                <tbody class="divide-y divide-slate-50">
                @foreach($messages as $msg)
                    <tr class="hover:bg-white/60 transition-colors group {{ $msg->is_read ? 'opacity-60' : '' }}">
                        <td class="p-6">
                            @if(!$msg->is_read)
                                <span class="px-3 py-1 bg-[#3fae2a] text-white text-[9px] font-black rounded-full uppercase tracking-tighter">Yeni</span>
                            @else
                                <span class="px-3 py-1 bg-slate-200 text-slate-500 text-[9px] font-black rounded-full uppercase tracking-tighter">Okundu</span>
                            @endif
                        </td>
                        <td class="p-6">
                            <div class="flex flex-col">
                                <span class="font-black text-slate-800 tracking-tight">{{ $msg->name }}</span>
                                <span class="text-[11px] text-slate-400 font-bold">{{ $msg->email }}</span>
                            </div>
                        </td>
                        <td class="p-6">
                            <span class="text-sm font-bold text-slate-600 italic">"{{ Str::limit($msg->subject, 30) }}"</span>
                        </td>
                        <td class="p-6 text-xs font-bold text-slate-400">
                            {{ $msg->created_at->diffForHumans() }}
                        </td>
                        <td class="p-6 text-right">
                            <div class="flex justify-end gap-2">
                                <button onclick="viewMessage({{ json_encode($msg) }})" class="w-10 h-10 glass-darker rounded-xl flex items-center justify-center text-slate-600 hover:bg-slate-900 hover:text-white transition-all shadow-sm">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/></svg>
                                </button>
                                <form action="{{ route('admin.messages.destroy', $msg->id) }}" method="POST" onsubmit="return confirm('Bu mesajı silmek istediğinize emin misiniz?')">
                                    @csrf @method('DELETE')
                                    <button class="w-10 h-10 glass-darker rounded-xl flex items-center justify-center text-[#e31e23] hover:bg-[#e31e23] hover:text-white transition-all shadow-sm">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <div id="messageModal" class="fixed inset-0 z-[100] hidden">
        <div class="absolute inset-0 bg-slate-900/40 backdrop-blur-md"></div>
        <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-full max-w-2xl p-6">
            <div class="glass-darker rounded-[48px] p-12 border border-white shadow-2xl relative overflow-hidden">
                <button onclick="closeModal()" class="absolute top-8 right-8 text-slate-400 hover:text-slate-900">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></button>

                <div class="space-y-8">
                    <div class="pb-6 border-b border-slate-100">
                        <h2 id="modalSubject" class="text-3xl font-black text-slate-900 tracking-tighter mb-2 italic">Konu Başlığı</h2>
                        <p id="modalSender" class="text-sm font-bold text-[#3fae2a] uppercase tracking-widest">Gönderen Adı</p>
                    </div>
                    <div id="modalContent" class="text-slate-600 leading-relaxed text-lg italic">
                        Mesaj içeriği buraya gelecek...
                    </div>
                    <div class="pt-6">
                        <button onclick="closeModal()" class="w-full bg-slate-900 text-white py-5 rounded-3xl font-black uppercase text-xs tracking-widest">Kapat</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function viewMessage(msg) {
            document.getElementById('modalSubject').innerText = msg.subject;
            document.getElementById('modalSender').innerText = msg.name + ' (' + msg.email + ')';
            document.getElementById('modalContent').innerText = msg.message;
            document.getElementById('messageModal').classList.remove('hidden');

            // Okundu olarak işaretlemek için backend isteği atılabilir
            fetch(`/admin/messages/${msg.id}/read`, {
                method: 'POST',
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
            }).then(() => {
                // İsteğe bağlı sayfayı yenilemeden UI güncelleme
            });
        }

        function closeModal() {
            document.getElementById('messageModal').classList.add('hidden');
        }
    </script>
@endsection
