@extends('admin.pages.build')
@section('title', 'Sertifika Yönetimi')

@section('content')
    <div class="w-full mx-auto">
        <div class="flex flex-col sm:flex-row justify-between items-center mb-6 bg-white p-4 rounded-lg shadow-sm border border-gray-100">
            <h3 class="text-xl font-bold text-gray-800">Sertifika Listesi</h3>
            <a href="{{ route('certificates.create') }}"
               class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition-colors duration-200 shadow-sm">
                + Yeni Ekle
            </a>
        </div>

        <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider w-16">#</th>
                        <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider w-32">Görsel</th>
                        <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">Başlık</th>
                        <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">Alt Başlık</th>
                        <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">Sıra</th>
                        <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">Durum</th>
                        <th class="px-6 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider w-40">İşlem</th>
                    </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($certificates as $cert)
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 text-sm text-gray-500">{{ $cert->id }}</td>
                            <td class="px-6 py-4">
                                <img class="h-16 w-12 object-cover rounded border border-gray-200" src="{{ asset($cert->image) }}">
                            </td>
                            <td class="px-6 py-4 text-sm font-medium text-gray-900">{{ $cert->title }}</td>
                            <td class="px-6 py-4 text-sm text-gray-500">{{ $cert->subtitle }}</td>
                            <td class="px-6 py-4 text-sm text-gray-700 font-bold">{{ $cert->rank }}</td>
                            <td class="px-6 py-4">
                                @if($cert->is_active)
                                    <span class="px-2 py-1 text-xs font-medium bg-green-100 text-green-800 rounded-full border border-green-200">Aktif</span>
                                @else
                                    <span class="px-2 py-1 text-xs font-medium bg-red-100 text-red-800 rounded-full border border-red-200">Pasif</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 flex gap-2">
                                <a href="{{ route('certificates.edit', $cert->id) }}" class="text-amber-600 bg-amber-50 px-3 py-1 rounded border border-amber-200 hover:bg-amber-100">Düzenle</a>
                                <form action="{{ route('certificates.destroy', $cert->id) }}" method="POST" onsubmit="return confirm('Silinsin mi?')">
                                    @csrf @method('DELETE')
                                    <button type="submit" class="text-red-600 bg-red-50 px-3 py-1 rounded border border-red-200 hover:bg-red-100">Sil</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection