@extends('admin.pages.build')
@section('title', isset($certificate) ? 'Sertifika Düzenle' : 'Yeni Sertifika')

@section('content')
    <div class="max-w-4xl mx-auto">
        <div class="bg-white rounded-lg shadow-sm border border-gray-200">
            <div class="px-6 py-4 border-b border-gray-200 bg-gray-50 rounded-t-lg">
                <h3 class="text-lg font-bold text-gray-800">
                    {{ isset($certificate) ? 'Sertifika Düzenle' : 'Yeni Sertifika Ekle' }}
                </h3>
            </div>
            <div class="p-6">
                <form action="{{ isset($certificate) ? route('certificates.update', $certificate->id) : route('certificates.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @if(isset($certificate)) @method('PUT') @endif

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

                        <div class="col-span-1">
                            <label class="block mb-2 text-sm font-medium text-gray-900">Sertifika Görseli (Zorunlu)</label>
                            <input type="file" name="image" class="block w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 file:mr-4 file:py-2 file:px-4 file:rounded-l-lg file:border-0 file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 transition">
                            @if(isset($certificate))
                                <div class="mt-3 p-1 bg-white border border-gray-200 rounded-lg inline-block shadow-sm">
                                    <img src="{{ asset($certificate->image) }}" class="h-32 w-auto object-contain rounded">
                                </div>
                            @endif
                        </div>

                        <div class="col-span-1">
                            <label class="block mb-2 text-sm font-medium text-gray-900">Sıralama (Rank)</label>
                            <input type="number" name="rank" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg block w-full p-2.5" value="{{ old('rank', $certificate->rank ?? 0) }}">
                        </div>

                        <div class="col-span-1 md:col-span-2">
                            <label class="block mb-2 text-sm font-medium text-gray-900">Başlık (Örn: ISO 9001)</label>
                            <input type="text" name="title" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg block w-full p-2.5" value="{{ old('title', $certificate->title ?? '') }}">
                        </div>

                        <div class="col-span-1 md:col-span-2">
                            <label class="block mb-2 text-sm font-medium text-gray-900">Alt Açıklama (Örn: Kalite Yönetim Sistemi)</label>
                            <input type="text" name="subtitle" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg block w-full p-2.5" value="{{ old('subtitle', $certificate->subtitle ?? '') }}">
                        </div>

                        <div class="col-span-1">
                            <label class="block mb-2 text-sm font-medium text-gray-900">Durum</label>
                            <select name="is_active" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg block w-full p-2.5">
                                <option value="1" {{ (old('is_active', $certificate->is_active ?? 1) == 1) ? 'selected' : '' }}>Aktif</option>
                                <option value="0" {{ (old('is_active', $certificate->is_active ?? 1) == 0) ? 'selected' : '' }}>Pasif</option>
                            </select>
                        </div>
                    </div>

                    <div class="mt-8 flex justify-end">
                        <button type="submit" class="text-white bg-green-600 hover:bg-green-700 font-bold rounded-lg text-sm px-8 py-3 shadow-md transition-colors">Kaydet</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection