@extends('admin.pages.build')
@section('header', isset($branch) ? 'Şube Düzenle' : 'Yeni Şube Ekle')

@section('content')
    <div class="max-w-3xl mx-auto">
        <div class="bg-white rounded-[2.5rem] shadow-sm border border-gray-100 p-8 md:p-12">
            <form action="{{ isset($branch) ? route('branches.update', $branch->id) : route('branches.store') }}" method="POST">
                @csrf
                @if(isset($branch)) @method('PUT') @endif

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="md:col-span-1">
                        <label class="block text-sm font-bold text-[#3a4b3a] mb-2">İl Seçiniz</label>
                        <select name="city_plate" id="city_select" required class="w-full px-5 py-4 bg-gray-50 border border-gray-200 rounded-2xl outline-none focus:border-asil-green transition"
                                onchange="document.getElementById('city_name').value = this.options[this.selectedIndex].text">
                            <option value="">Plaka Seçiniz</option>
                            @php
                                $cities = [
                                    '01' => 'Adana', '02' => 'Adıyaman', '03' => 'Afyonkarahisar', '04' => 'Ağrı', '05' => 'Amasya',
                                    '06' => 'Ankara', '07' => 'Antalya', '08' => 'Artvin', '09' => 'Aydın', '10' => 'Balıkesir',
                                    '11' => 'Bilecik', '12' => 'Bingöl', '13' => 'Bitlis', '14' => 'Bolu', '15' => 'Burdur',
                                    '16' => 'Bursa', '17' => 'Çanakkale', '18' => 'Çankırı', '19' => 'Çorum', '20' => 'Denizli',
                                    '21' => 'Diyarbakır', '22' => 'Edirne', '23' => 'Elazığ', '24' => 'Erzincan', '25' => 'Erzurum',
                                    '26' => 'Eskişehir', '27' => 'Gaziantep', '28' => 'Giresun', '29' => 'Gümüşhane', '30' => 'Hakkari',
                                    '31' => 'Hatay', '32' => 'Isparta', '33' => 'Mersin', '34' => 'İstanbul', '35' => 'İzmir',
                                    '36' => 'Kars', '37' => 'Kastamonu', '38' => 'Kayseri', '39' => 'Kırklareli', '40' => 'Kırşehir',
                                    '41' => 'Kocaeli', '42' => 'Konya', '43' => 'Kütahya', '44' => 'Malatya', '45' => 'Manisa',
                                    '46' => 'Kahramanmaraş', '47' => 'Mardin', '48' => 'Muğla', '49' => 'Muş', '50' => 'Nevşehir',
                                    '51' => 'Niğde', '52' => 'Ordu', '53' => 'Rize', '54' => 'Sakarya', '55' => 'Samsun',
                                    '56' => 'Siirt', '57' => 'Sinop', '58' => 'Sivas', '59' => 'Tekirdağ', '60' => 'Tokat',
                                    '61' => 'Trabzon', '62' => 'Tunceli', '63' => 'Şanlıurfa', '64' => 'Uşak', '65' => 'Van',
                                    '66' => 'Yozgat', '67' => 'Zonguldak', '68' => 'Aksaray', '69' => 'Bayburt', '70' => 'Karaman',
                                    '71' => 'Kırıkkale', '72' => 'Batman', '73' => 'Şırnak', '74' => 'Bartın', '75' => 'Ardahan',
                                    '76' => 'Iğdır', '77' => 'Yalova', '78' => 'Karabük', '79' => 'Kilis', '80' => 'Osmaniye', '81' => 'Düzce'
                                ];
                            @endphp
                            @foreach($cities as $plate => $name)
                                <option value="{{ $plate }}" {{ (isset($branch) && $branch->city_plate == $plate) ? 'selected' : '' }}>{{ $name }}</option>
                            @endforeach
                        </select>
                        <input type="hidden" name="city_name" id="city_name" value="{{ $branch->city_name ?? '' }}">
                    </div>

                    <div style="display: none">
                        <label class="block text-sm font-bold text-[#3a4b3a] mb-2">Şube Türü</label>
                        <select name="type" class="w-full px-5 py-4 bg-gray-50 border border-gray-200 rounded-2xl outline-none focus:border-asil-green transition">
                            <option value="Şube" {{ (isset($branch) && $branch->type == 'Şube') ? 'selected' : '' }}>Şube</option>
                            <option value="Express" {{ (isset($branch) && $branch->type == 'Express') ? 'selected' : '' }}>Express</option>
                            <option value="Kiosk" {{ (isset($branch) && $branch->type == 'Kiosk') ? 'selected' : '' }}>Kiosk</option>
                        </select>
                    </div>

                    <div class="md:col-span-2">
                        <label class="block text-sm font-bold text-[#3a4b3a] mb-2">Şube Adı</label>
                        <input type="text" name="name" required value="{{ $branch->name ?? '' }}" class="w-full px-5 py-4 bg-gray-50 border border-gray-200 rounded-2xl outline-none focus:border-asil-green transition" placeholder="Örn: Sincan Merkez Şube">
                    </div>

                    <div class="md:col-span-2">
                        <label class="block text-sm font-bold text-[#3a4b3a] mb-2">Açık Adres</label>
                        <textarea name="address" required rows="3" class="w-full px-5 py-4 bg-gray-50 border border-gray-200 rounded-2xl outline-none focus:border-asil-green transition" placeholder="Şube açık adresi...">{{ $branch->address ?? '' }}</textarea>
                    </div>

                    <div>
                        <label class="block text-sm font-bold text-[#3a4b3a] mb-2">Telefon</label>
                        <input type="text" name="phone" value="{{ $branch->phone ?? '' }}" class="w-full px-5 py-4 bg-gray-50 border border-gray-200 rounded-2xl outline-none focus:border-asil-green transition" placeholder="0212 XXX XX XX">
                    </div>

                    <div>
                        <label class="block text-sm font-bold text-[#3a4b3a] mb-2">Google Maps Yol Tarifi Linki</label>
                        <div class="relative">
                            <input type="url" name="map_link" value="{{ $branch->map_link ?? '' }}"
                                   class="w-full px-5 py-4 bg-gray-50 border border-gray-200 rounded-2xl outline-none focus:border-asil-green transition pl-12"
                                   placeholder="https://maps.google.com/...">
                            <div class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400">
                                <i class="fa-solid fa-route"></i>
                            </div>
                        </div>
                        <p class="text-[10px] text-gray-400 mt-2 ml-1 italic">* Google Haritalar'daki "Paylaş" kısmından alınan linki yapıştırın.</p>
                    </div>

                    <div class="flex items-center pt-8">
                        <label class="flex items-center gap-3 cursor-pointer">
                            <input type="checkbox" name="is_active" value="1" class="w-5 h-5 rounded text-asil-green" {{ (isset($branch) && !$branch->is_active) ? '' : 'checked' }}>
                            <span class="text-sm font-bold text-asil-dark">Yayında</span>
                        </label>
                    </div>
                </div>

                <div class="pt-8 mt-8 border-t flex gap-4">
                    <button type="submit" class="bg-asil-dark text-white px-8 py-4 rounded-2xl font-bold hover:bg-asil-green transition shadow-lg">
                        <i class="fa-solid fa-save mr-2"></i> Şubeyi Kaydet
                    </button>
                    <a href="{{ route('branches.index') }}" class="px-8 py-4 text-gray-400 font-bold">Vazgeç</a>
                </div>
            </form>
        </div>
    </div>
@endsection
