<?php

namespace App\Providers;

use App\Models\Setting;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Veritabanı henüz oluşturulmamışsa (migration atılmamışsa) hata vermemesi için tablo kontrolü yapıyoruz
        if (Schema::hasTable('settings')) {

            /**
             * pluck('value', 'key'):
             * 'key' sütununu dizinin anahtarı, 'value' sütununu ise değeri yapar.
             * Örn: ['phone' => '0212...', 'logo' => 'uploads/...']
             */
            $site_settings = Setting::pluck('value', 'key')->all();

            // Tüm view dosyalarında (site ve admin) bu değişkeni paylaş
            View::share('site_settings', $site_settings);
        }
    }
}
