<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;

    /**
     * Toplu atama yapılabilecek sütunlar.
     * key-value yapısını korumak için sadece bu iki alan yeterlidir.
     */
    protected $fillable = [
        'key',
        'value'
    ];

    /**
     * Eğer ID yerine doğrudan KEY üzerinden işlem yapmak isterseniz
     * bu modelde primaryKey olarak key sütununu da tanımlayabilirsiniz (Opsiyonel).
     */
}
