<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Branch extends Model
{
    use HasFactory;

    /**
     * Veritabanına toplu olarak kaydedilmesine izin verilen sütunlar.
     */
    protected $fillable = [
        'city_plate',  // Plaka kodu (06, 34 vb.)
        'city_name',   // İl adı (Ankara, İstanbul vb.)
        'name',        // Şube adı (Kızılay Şubesi vb.)
        'type',        // Şube tipi (Express, Kiosk, Restoran)
        'address',     // Açık adres
        'phone',       // İletişim numarası
        'map_link',    // Google Maps paylaşım linki
        'is_active'    // Sitede yayında mı?
    ];

    /**
     * Veritabanından gelen verilerin otomatik tip dönüşümleri.
     */
    protected $casts = [
        'is_active' => 'boolean', // 0/1 değerini true/false olarak döner
    ];

    /**
     * Varsayılan değerler.
     */
    protected $attributes = [
        'is_active' => true,
        'type' => 'Şube',
    ];
}
