<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Slider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class SliderController extends Controller
{
    public function index()
    {
        $sliders = Slider::orderBy('rank', 'asc')->get();
        return view('admin.sliders.index', compact('sliders'));
    }

    public function create()
    {
        return view('admin.sliders.form');
    }

    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,webp|max:2048',
            'title' => 'nullable|string',
        ]);

        $data = $request->except('image');

        if ($request->hasFile('image')) {
            // Resmi 'public/uploads/sliders' klasörüne kaydet
            $file = $request->file('image');
            $filename = time() . '_' . $file->getClientOriginalName();
            $file->move(public_path('uploads/sliders'), $filename);
            $data['image'] = 'uploads/sliders/' . $filename;
        }

        Slider::create($data);

        return redirect()->route('sliders.index')->with('success', 'Slider başarıyla eklendi.');
    }

    public function edit($id)
    {
        $slider = Slider::findOrFail($id);
        return view('admin.sliders.form', compact('slider'));
    }

    public function update(Request $request, $id)
    {
        $slider = Slider::findOrFail($id);

        $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:2048',
        ]);

        $data = $request->except('image');

        if ($request->hasFile('image')) {
            // Eski resmi sil (Opsiyonel)
            if(file_exists(public_path($slider->image))) {
                unlink(public_path($slider->image));
            }

            // Yeni resmi yükle
            $file = $request->file('image');
            $filename = time() . '_' . $file->getClientOriginalName();
            $file->move(public_path('uploads/sliders'), $filename);
            $data['image'] = 'uploads/sliders/' . $filename;
        }

        $slider->update($data);

        return redirect()->route('sliders.index')->with('success', 'Slider güncellendi.');
    }

    public function destroy($id)
    {
        $slider = Slider::findOrFail($id);
        if(file_exists(public_path($slider->image))) {
            unlink(public_path($slider->image));
        }
        $slider->delete();
        return redirect()->route('sliders.index')->with('success', 'Silindi.');
    }
}