<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use Illuminate\Http\Request;

class BranchController extends Controller
{
    public function index() {
        $branches = Branch::orderBy('city_plate')->get();
        return view('admin.branches.index', compact('branches'));
    }

    public function create() {
        return view('admin.branches.form');
    }

    public function store(Request $request) {
        $request->validate(['name' => 'required', 'city_plate' => 'required', 'address' => 'required']);
        Branch::create($request->all());
        return redirect()->route('branches.index')->with('success', 'Şube eklendi.');
    }

    public function edit(Branch $branch) {
        return view('admin.branches.form', compact('branch'));
    }

    public function update(Request $request, Branch $branch) {
        $branch->update($request->all());
        return redirect()->route('branches.index')->with('success', 'Şube güncellendi.');
    }

    public function destroy(Branch $branch) {
        $branch->delete();
        return back()->with('success', 'Şube silindi.');
    }
}
