<?php

namespace App\Http\Controllers;

use App\Models\Application;
use Illuminate\Http\Request;

class ApplicationController extends Controller
{
    // Formu Veritabanına Kaydet
    public function store(Request $request)
    {
        $validated = $request->validate([
            'ad_soyad' => 'required|string|max:255',
            'telefon'  => 'required|string',
            'email'    => 'required|email',
            'lokasyon' => 'required|string',
            'deneyim'  => 'required',
            'kvkk_onay'=> 'required'
        ]);

        Application::create($validated);

        return back()->with('success', 'Başvurunuz başarıyla iletildi. En kısa sürede sizinle iletişime geçeceğiz.');
    }

    // Admin Paneli: Başvuruları Listele
    public function index()
    {
        $applications = Application::latest()->get();
        return view('admin.applications.index', compact('applications'));
    }
}
