<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\Request;
use File;
use App\Models\Message;

class AdminController extends Controller
{
    public function settings()
    {
        $settings = Setting::pluck('value', 'key')->all();
        return view('admin.settings.index', compact('settings'));
    }

    public function updateSettings(Request $request)
    {
        $data = $request->except(['_token', 'logo', 'favicon']);

        // Metin ayarlarını kaydet
        foreach ($data as $key => $value) {
            Setting::updateOrCreate(['key' => $key], ['value' => $value]);
        }

        // Logo Yükleme
        if ($request->hasFile('logo')) {
            $this->uploadToPublic($request, 'logo');
        }

        // Favicon Yükleme
        if ($request->hasFile('favicon')) {
            $this->uploadToPublic($request, 'favicon');
        }

        return back()->with('success', 'Tüm ayarlar başarıyla güncellendi.');
    }

    // Public klasörüne doğrudan yükleme yapan fonksiyon
    private function uploadToPublic($request, $key)
    {
        $file = $request->file($key);
        $fileName = $key . '-' . time() . '.' . $file->getClientOriginalExtension();

        // public/uploads/assets klasörüne taşır
        $file->move(public_path('uploads/assets'), $fileName);

        // Eski dosyayı temizle (Opsiyonel)
        $oldSetting = Setting::where('key', $key)->first();
        if ($oldSetting && $oldSetting->value) {
            $oldPath = public_path($oldSetting->value);
            if (File::exists($oldPath)) {
                File::delete($oldPath);
            }
        }

        // Veritabanına yeni yolu kaydet
        Setting::updateOrCreate(['key' => $key], ['value' => 'uploads/assets/' . $fileName]);
    }

    public function sendMessage(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'subject' => 'required|string|max:255',
            'message' => 'required|string',
        ]);

        Message::create($request->all());

        return back()->with('success', 'Mesajınız başarıyla iletildi. En kısa sürede dönüş yapacağız.');
    }

    // Mesajları Listele
    public function messages()
    {
        $messages = \App\Models\Message::latest()->get();
        return view('admin.messages.index', compact('messages'));
    }

// Okundu Olarak İşaretle (AJAX için)
    public function markAsRead($id)
    {
        $message = \App\Models\Message::findOrFail($id);
        $message->update(['is_read' => true]);
        return response()->json(['success' => true]);
    }

// Mesajı Sil
    public function destroyMessage($id)
    {
        \App\Models\Message::findOrFail($id)->delete();
        return back()->with('success', 'Mesaj kalıcı olarak silindi.');
    }
}
